/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.data.compare.model;

import com.dbeaver.data.compare.model.DCChangeList;
import com.dbeaver.data.compare.model.DCChangeOrder;
import com.dbeaver.data.compare.model.DCChangeRelation;
import com.dbeaver.data.compare.model.DCChangeSet;
import com.dbeaver.data.compare.model.DCInput;
import com.dbeaver.data.compare.model.DCIterator;
import com.dbeaver.data.compare.model.DCSettings;
import com.dbeaver.data.compare.model.DCSummary;
import com.dbeaver.data.compare.model.exporter.DCExporter;
import com.dbeaver.data.compare.model.exporter.DCExporterDescriptor;
import com.dbeaver.data.compare.model.exporter.DCExporterSite;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.text.MessageFormat;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPContextProvider;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.impl.DataSourceContextProvider;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLQuery;
import org.jkiss.dbeaver.model.sql.SQLScriptContext;
import org.jkiss.dbeaver.model.sql.data.SQLQueryDataContainer;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class DCUtils {
    private DCUtils() {
    }

    public static void exportChanges(@NotNull DBRProgressMonitor monitor, @NotNull DCSummary summary, @NotNull DCExporterDescriptor descriptor, @NotNull Path path, @NotNull DCChangeRelation relation, @NotNull DCChangeOrder order) throws IOException, DBException {
        DCUtils.exportChanges(monitor, summary, descriptor, path, relation, order, 0L, Long.MAX_VALUE);
    }

    public static void exportChanges(@NotNull DBRProgressMonitor monitor, @NotNull DCSummary summary, @NotNull DCExporterDescriptor descriptor, @NotNull Path path, @NotNull DCChangeRelation relation, @NotNull DCChangeOrder order, long offset, long count) throws IOException, DBException {
        Throwable throwable = null;
        Object var11_10 = null;
        try (BufferedWriter writer = Files.newBufferedWriter(path, StandardCharsets.UTF_8, new OpenOption[0]);){
            DCUtils.exportChanges(monitor, summary, descriptor, writer, relation, order, offset, count);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static void exportChanges(@NotNull DBRProgressMonitor monitor, @NotNull DCSummary summary, @NotNull DCExporterDescriptor descriptor, @NotNull Writer writer, @NotNull DCChangeRelation relation, @NotNull DCChangeOrder order, long offset, long count) throws IOException, DBException {
        DCInput input = summary.getSettings().getInput(relation);
        DCExporter exporter = descriptor.createExporter();
        exporter.init(new ExporterSite(summary.getSettings(), writer, relation));
        DCChangeList changeList = summary.getChangeList();
        monitor.beginTask("Export changes", changeList.size());
        try {
            Throwable throwable = null;
            Object var14_13 = null;
            try (DBCSession session = input.getExecutionContext().openSession(monitor, DBCExecutionPurpose.UTIL, "Export changes");){
                Throwable throwable2 = null;
                Object var17_18 = null;
                try (DCIterator<DCChangeSet> it = changeList.iterator(offset, count, order);){
                    exporter.exportHeader(session);
                    long progress = 0L;
                    while (!monitor.isCanceled() && it.hasNext()) {
                        exporter.exportRow(session, it.next());
                        monitor.worked(1);
                        if (++progress % 1000L != 0L) continue;
                        monitor.subTask(MessageFormat.format("Generated {0,number}/{1,number} change actions ({2}%)", progress, changeList.size(), progress * 100L / (long)changeList.size()));
                    }
                    exporter.exportFooter(session);
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        finally {
            monitor.done();
        }
    }

    @NotNull
    public static DBSDataContainer createDataContainerFromQuery(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSourceContainer container, @NotNull String query) throws DBException {
        DBUtils.initDataSource((DBRProgressMonitor)monitor, (DBPDataSourceContainer)container, null);
        DBPDataSource dataSource = container.getDataSource();
        if (dataSource == null) {
            throw new DBException("Can't connect to data source");
        }
        return DCUtils.createDataContainerFromQuery(dataSource, query);
    }

    @NotNull
    public static DBSDataContainer createDataContainerFromQuery(@NotNull DBPDataSource dataSource, @NotNull String query) {
        DataSourceContextProvider contextProvider = new DataSourceContextProvider((DBSObject)dataSource);
        return new SQLQueryDataContainer((DBPContextProvider)contextProvider, new SQLQuery(dataSource, query), new SQLScriptContext(null, (DBPContextProvider)contextProvider, null, (Writer)new PrintWriter(System.err, true), null), null);
    }

    private record ExporterSite(@NotNull DCSettings settings, @NotNull Writer writer, @NotNull DCChangeRelation relation) implements DCExporterSite
    {
        @Override
        @NotNull
        public DCSettings getSettings() {
            return this.settings;
        }

        @Override
        @NotNull
        public DCInput getInput() {
            return this.settings.getInput(this.relation);
        }

        @Override
        @NotNull
        public Writer getWriter() {
            return this.writer;
        }

        @Override
        @NotNull
        public DCChangeRelation getRelation() {
            return this.relation;
        }
    }
}

