/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.data.transfer.ui.ai.function;

import com.dbeaver.model.ai.AIUtilsPro;
import java.util.List;
import java.util.Map;
import org.eclipse.ui.IWorkbenchWindow;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.ai.AIFunction;
import org.jkiss.dbeaver.model.ai.AIFunctionContext;
import org.jkiss.dbeaver.model.ai.AIFunctionResult;
import org.jkiss.dbeaver.model.data.json.JSONUtils;
import org.jkiss.dbeaver.model.runtime.DBRRunnableWithReturn;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSDataManipulator;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseTransferConsumer;
import org.jkiss.dbeaver.tools.transfer.ui.wizard.DataTransferWizard;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.utils.CommonUtils;

public class AIFunctionImportData
implements AIFunction {
    public static final String PARAM_TARGET_TABLE = "targetTable";

    @NotNull
    public AIFunctionResult callFunction(@NotNull AIFunctionContext context, @NotNull Map<String, Object> parameters) throws DBException {
        String targetTableName = JSONUtils.getString(parameters, (String)PARAM_TARGET_TABLE);
        if (CommonUtils.isEmpty((String)targetTableName)) {
            throw new DBException("Target table name parameter is missing");
        }
        DBSDataContainer targetTable = AIUtilsPro.findTableInContext((AIFunctionContext)context, (String)targetTableName);
        DBRRunnableWithReturn callback = monitor -> {
            UIUtils.asyncExec(() -> DataTransferWizard.openWizard((IWorkbenchWindow)UIUtils.getActiveWorkbenchWindow(), List.of(), List.of(new DatabaseTransferConsumer((DBSDataManipulator)targetTable))));
            return null;
        };
        callback.runTask(context.getMonitor());
        return new AIFunctionResult(AIFunctionResult.FunctionType.ACTION, "Import data to '" + targetTableName + "'", callback);
    }
}

