/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.bigquery.model;

import com.dbeaver.db.bigquery.model.BigQueryDataSourcePro;
import com.dbeaver.db.bigquery.model.BigQueryTableColumnDataType;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ext.generic.model.GenericTableBase;
import org.jkiss.dbeaver.ext.generic.model.GenericTableColumn;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.meta.PropertyLength;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.dbeaver.model.struct.DBSTypedObjectEx;

public class BigQueryTableColumn
extends GenericTableColumn
implements DBSTypedObjectEx {
    private final boolean partitioningColumn;
    private final int clusteringOrderPosition;
    private final String collation;
    private final String shortTypeName;
    private BigQueryTableColumnDataType columnDataType;

    public BigQueryTableColumn(DBRProgressMonitor monitor, JDBCResultSet dbResult, GenericTableBase table, String columnName, String typeName, int valueType, int sourceType, int ordinalPos, long columnSize, long charLength, Integer scale, Integer precision, int radix, boolean notNull, String remarks, String defaultValue, boolean autoIncrement, boolean autoGenerated) {
        super(table, columnName, typeName, valueType, sourceType, ordinalPos, columnSize, charLength, scale, precision, radix, notNull, remarks, defaultValue, autoIncrement, autoGenerated);
        this.shortTypeName = typeName;
        this.partitioningColumn = false;
        this.clusteringOrderPosition = 0;
        this.collation = null;
    }

    public BigQueryTableColumn(DBRProgressMonitor progressMonitor, JDBCResultSet dbResult, GenericTableBase table, String columnName, String typeName, String fullTypeName, int valueType, int ordinalPos, long columnSize, boolean isNotNull, String defaultValue, boolean autoGenerated, boolean partitioningColumn, int clusteringOrderPosition, String collation) {
        super(table, columnName, fullTypeName, valueType, valueType, ordinalPos, columnSize, columnSize, null, null, 10, isNotNull, null, defaultValue, false, autoGenerated);
        this.shortTypeName = typeName;
        this.partitioningColumn = partitioningColumn;
        this.clusteringOrderPosition = clusteringOrderPosition;
        this.collation = collation;
        if ("STRUCT".equals(typeName)) {
            this.columnDataType = new BigQueryTableColumnDataType(this, DBPDataKind.STRUCT);
        } else if ("ARRAY".equals(typeName)) {
            this.columnDataType = new BigQueryTableColumnDataType(this, DBPDataKind.ARRAY);
        }
    }

    @NotNull
    public BigQueryDataSourcePro getDataSource() {
        return (BigQueryDataSourcePro)super.getDataSource();
    }

    @Nullable
    public Integer getScale() {
        return null;
    }

    @Nullable
    public Integer getPrecision() {
        return null;
    }

    public boolean isAutoIncrement() {
        return false;
    }

    @Property(length=PropertyLength.MULTILINE, order=20)
    @NotNull
    public String getFullTypeName() {
        return this.getTypeName();
    }

    @Property
    public boolean isPartitioningColumn() {
        return this.partitioningColumn;
    }

    @Property
    public int getClusteringOrderPosition() {
        return this.clusteringOrderPosition;
    }

    @Property
    public String getCollation() {
        return this.collation;
    }

    @NotNull
    public DBPDataKind getDataKind() {
        return this.columnDataType != null ? this.columnDataType.getDataKind() : super.getDataKind();
    }

    @Nullable
    public DBSDataType getDataType() {
        return this.columnDataType;
    }
}

