/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.bigquery.model;

import com.dbeaver.db.bigquery.model.BigQueryTable;
import com.dbeaver.db.bigquery.model.BigQueryUniqueKey;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.ext.generic.model.GenericTableBase;
import org.jkiss.dbeaver.ext.generic.model.GenericTableColumn;
import org.jkiss.dbeaver.ext.generic.model.GenericTableConstraintColumn;
import org.jkiss.dbeaver.ext.generic.model.TableCache;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCCompositeCache;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCStructCache;
import org.jkiss.dbeaver.model.impl.jdbc.struct.JDBCTableConstraint;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraintType;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.CommonUtils;

public class BigQueryUniqueConstraintCache
extends JDBCCompositeCache<GenericStructContainer, BigQueryTable, BigQueryUniqueKey, GenericTableConstraintColumn> {
    public BigQueryUniqueConstraintCache(TableCache tableCache) {
        super((JDBCStructCache)tableCache, BigQueryTable.class, (Object)"table_name", (Object)"constraint_name");
    }

    @NotNull
    protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull GenericStructContainer owner, @Nullable BigQueryTable table) throws SQLException {
        String sql = "SELECT c.* FROM " + DBUtils.getQuotedIdentifier((DBSObject)table.getCatalog()) + "." + DBUtils.getQuotedIdentifier((DBSObject)table.getSchema()) + ".INFORMATION_SCHEMA.TABLE_CONSTRAINTS b\nJOIN " + DBUtils.getQuotedIdentifier((DBSObject)table.getCatalog()) + "." + DBUtils.getQuotedIdentifier((DBSObject)table.getSchema()) + ".INFORMATION_SCHEMA.KEY_COLUMN_USAGE c  ON b.CONSTRAINT_NAME = c.CONSTRAINT_NAME\nWHERE b.TABLE_SCHEMA = ? AND b.TABLE_NAME = ? AND b.CONSTRAINT_TYPE = ?";
        JDBCPreparedStatement statement = session.prepareStatement(sql);
        statement.setString(1, table.getSchema().getName());
        statement.setString(2, table.getName());
        statement.setString(3, DBSEntityConstraintType.PRIMARY_KEY.getName());
        return statement;
    }

    protected BigQueryUniqueKey fetchObject(@NotNull JDBCSession session, @NotNull GenericStructContainer owner, @NotNull BigQueryTable parent, @NotNull String childName, @NotNull JDBCResultSet dbResult) throws SQLException, DBException {
        String projectName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"CONSTRAINT_CATALOG");
        String schemaName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"CONSTRAINT_SCHEMA");
        String constraintName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"CONSTRAINT_NAME");
        String columnName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"COLUMN_NAME");
        int position = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"ORDINAL_POSITION");
        Integer positionInQnuque = JDBCUtils.safeGetInteger((ResultSet)dbResult, (String)"POSITION_IN_UNIQUE_CONSTRAINT");
        return new BigQueryUniqueKey(projectName, schemaName, (GenericTableBase)parent, columnName, constraintName, "", DBSEntityConstraintType.PRIMARY_KEY, true, position, positionInQnuque);
    }

    protected GenericTableConstraintColumn[] fetchObjectRow(@NotNull JDBCSession session, @NotNull BigQueryTable parent, @NotNull BigQueryUniqueKey forObject, @NotNull JDBCResultSet resultSet) throws DBException {
        String columnName = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"COLUMN_NAME");
        if (CommonUtils.isEmpty((String)columnName)) {
            log.debug((Object)("Can't find constraint table column name for " + forObject.getName()));
            return null;
        }
        GenericTableColumn tableColumn = parent.getAttribute(session.getProgressMonitor(), columnName);
        if (tableColumn == null) {
            log.debug((Object)("Can't find constraint table column for " + forObject.getName()));
            return null;
        }
        int keySeq = JDBCUtils.safeGetInt((ResultSet)resultSet, (String)"ORDINAL_POSITION");
        return new GenericTableConstraintColumn[]{new GenericTableConstraintColumn((JDBCTableConstraint)forObject, tableColumn, keySeq)};
    }

    protected void cacheChildren(@NotNull DBRProgressMonitor monitor, @NotNull BigQueryUniqueKey object, @NotNull List<GenericTableConstraintColumn> children) {
        object.setAttributeReferences(children);
    }
}

