/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.cassandra.ui.views;

import com.datastax.oss.driver.api.core.ConsistencyLevel;
import com.datastax.oss.driver.api.core.DefaultConsistencyLevel;
import com.dbeaver.db.cassandra.model.CasExecutionContext;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.jkiss.dbeaver.model.DBPContextProvider;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.ui.ActionUtils;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.actions.datasource.DataSourceMenuContributor;

public class CasConsistencyLevelContributor
extends DataSourceMenuContributor {
    protected void fillContributionItems(List<IContributionItem> menuItems) {
        DBCExecutionContext executionContext;
        IWorkbenchWindow window = UIUtils.getActiveWorkbenchWindow();
        if (window == null) {
            return;
        }
        IEditorPart activePart = window.getActivePage().getActiveEditor();
        if (activePart instanceof DBPContextProvider && (executionContext = ((DBPContextProvider)activePart).getExecutionContext()) instanceof CasExecutionContext) {
            ConsistencyLevel currentCL = ((CasExecutionContext)executionContext).getCurrentConsistencyLevel();
            DefaultConsistencyLevel[] defaultConsistencyLevelArray = DefaultConsistencyLevel.values();
            int n = defaultConsistencyLevelArray.length;
            int n2 = 0;
            while (n2 < n) {
                DefaultConsistencyLevel cl = defaultConsistencyLevelArray[n2];
                menuItems.add((IContributionItem)ActionUtils.makeActionContribution((IAction)new ConsistencyLevelAction((CasExecutionContext)executionContext, (ConsistencyLevel)cl, cl.equals(currentCL)), (boolean)true));
                ++n2;
            }
        }
    }

    private static class ConsistencyLevelAction
    extends Action {
        private final CasExecutionContext executionContext;
        private final ConsistencyLevel level;
        private final boolean checked;

        public ConsistencyLevelAction(CasExecutionContext executionContext, ConsistencyLevel level, boolean isCurrent) {
            this.executionContext = executionContext;
            this.level = level;
            this.checked = isCurrent;
        }

        public int getStyle() {
            return 8;
        }

        public boolean isChecked() {
            return this.checked;
        }

        public String getText() {
            return this.level.name();
        }

        public void run() {
            this.executionContext.setCurrentConsistencyLevel(this.level);
        }
    }
}

