/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.cassandra.data.handlers;

import com.datastax.oss.driver.api.core.cql.BoundStatement;
import com.dbeaver.db.cassandra.exec.CasPreparedStatement;
import com.dbeaver.db.cassandra.exec.CasSession;
import java.util.ArrayList;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCLogicalOperator;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.impl.data.BaseValueHandler;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;

public abstract class CasBaseValueHandler
extends BaseValueHandler {
    private static final Log log = Log.getLog(CasBaseValueHandler.class);

    public Object fetchValueObject(@NotNull DBCSession session, @NotNull DBCResultSet resultSet, @NotNull DBSTypedObject type, int index) throws DBCException {
        return this.getValueFromObject(session, type, resultSet.getAttributeValue(index), false, false);
    }

    public final void bindValueObject(@NotNull DBCSession session, @NotNull DBCStatement statement, @NotNull DBSTypedObject columnMetaData, int index, Object value) throws DBCException {
        try {
            if (DBUtils.isNullValue((Object)value)) {
                ((CasPreparedStatement)statement).updateBoundStatement((BoundStatement)((CasPreparedStatement)statement).getBoundStatement().setToNull(index));
            } else {
                this.bindParameter((CasSession)session, (CasPreparedStatement)statement, columnMetaData, index, value);
            }
        }
        catch (Exception e) {
            throw new DBCException("Error binding statement parameter", (Throwable)e);
        }
    }

    protected abstract void bindParameter(CasSession var1, CasPreparedStatement var2, DBSTypedObject var3, int var4, Object var5) throws DBCException;

    @NotNull
    public DBCLogicalOperator[] getSupportedOperators(@NotNull DBSTypedObject attribute) {
        ArrayList<DBCLogicalOperator> operators = new ArrayList<DBCLogicalOperator>();
        DBPDataKind dataKind = attribute.getDataKind();
        if (dataKind == DBPDataKind.NUMERIC || dataKind == DBPDataKind.DATETIME || dataKind == DBPDataKind.STRING || dataKind == DBPDataKind.ROWID) {
            operators.addAll(List.of(DBCLogicalOperator.EQUALS, DBCLogicalOperator.GREATER, DBCLogicalOperator.LESS, DBCLogicalOperator.IN));
        }
        if (dataKind == DBPDataKind.ARRAY) {
            operators.addAll(List.of(DBCLogicalOperator.CONTAINS, DBCLogicalOperator.CONTAINS_KEY));
        }
        return operators.toArray(new DBCLogicalOperator[0]);
    }
}

