/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.cassandra.exec;

import com.datastax.oss.driver.api.core.cql.AsyncResultSet;
import com.datastax.oss.driver.api.core.cql.ColumnDefinition;
import com.datastax.oss.driver.api.core.cql.ColumnDefinitions;
import com.datastax.oss.driver.api.core.cql.ExecutionInfo;
import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.api.core.data.CqlVector;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.ListType;
import com.datastax.oss.driver.api.core.type.MapType;
import com.datastax.oss.driver.api.core.type.SetType;
import com.datastax.oss.driver.api.core.type.VectorType;
import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.driver.api.core.type.codec.registry.CodecRegistry;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import com.dbeaver.db.cassandra.data.CasListValue;
import com.dbeaver.db.cassandra.data.CasMapValue;
import com.dbeaver.db.cassandra.data.CasSetValue;
import com.dbeaver.db.cassandra.data.CasTupleValue;
import com.dbeaver.db.cassandra.data.CasUDTValue;
import com.dbeaver.db.cassandra.data.CasVectorValue;
import com.dbeaver.db.cassandra.exec.CasBaseStatement;
import com.dbeaver.db.cassandra.exec.CasQueryTrace;
import com.dbeaver.db.cassandra.exec.CasSession;
import com.dbeaver.db.cassandra.model.CasExecutionContext;
import com.dbeaver.db.cassandra.model.CasResultSetMetaData;
import com.dbeaver.model.data.DBContentByteBuffer;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCResultSetTrace;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.exec.trace.DBCTrace;
import org.jkiss.dbeaver.model.impl.AbstractResultSet;
import org.jkiss.dbeaver.model.qm.QMUtils;
import org.jkiss.utils.CommonUtils;

public class CasResultSet
extends AbstractResultSet<CasSession, CasBaseStatement>
implements DBCResultSetTrace {
    private final AsyncResultSet resultSet;
    private Iterator<Row> rowIterator;
    private CasResultSetMetaData metaData;
    private Row curRow;
    private ColumnDefinitions columnDefinitions;
    private long rowCount = 0L;

    public CasResultSet(CasBaseStatement statement, AsyncResultSet resultSet) {
        super((DBCSession)((CasSession)statement.getSession()), (DBCStatement)statement);
        ExecutionInfo executionInfo;
        this.resultSet = resultSet;
        this.rowIterator = resultSet.currentPage().iterator();
        long offset = statement.getOffset();
        if (offset > 0L) {
            int i = 0;
            while ((long)i < offset && this.rowIterator.hasNext()) {
                this.rowIterator.next();
                ++i;
            }
        }
        if (!CommonUtils.isEmpty((Collection)(executionInfo = resultSet.getExecutionInfo()).getWarnings())) {
            Iterator iterator = executionInfo.getWarnings().iterator();
            while (iterator.hasNext()) {
                String cfr_ignored_0 = (String)iterator.next();
            }
        }
        if (((CasSession)statement.getSession()).isLoggingEnabled()) {
            QMUtils.getDefaultHandler().handleResultSetOpen((DBCResultSet)this);
        }
    }

    public Object getAttributeValue(int index) throws DBCException {
        if (this.curRow == null) {
            throw new DBCException("You have to fetch a row");
        }
        if (this.curRow.isNull(index)) {
            return null;
        }
        ColumnDefinition type = this.columnDefinitions.get(index);
        CasExecutionContext executionContext = ((CasSession)this.getSession()).getExecutionContext();
        return switch (type.getType().getProtocolCode()) {
            case 1, 13 -> this.curRow.getString(index);
            case 20 -> Byte.valueOf(this.curRow.getByte(index));
            case 19 -> Short.valueOf(this.curRow.getShort(index));
            case 9 -> Integer.valueOf(this.curRow.getInt(index));
            case 2, 5 -> Long.valueOf(this.curRow.getLong(index));
            case 14 -> this.curRow.getToken(index);
            case 6 -> this.curRow.getBigDecimal(index);
            case 8 -> Float.valueOf(this.curRow.getFloat(index));
            case 7 -> Double.valueOf(this.curRow.getDouble(index));
            case 4 -> Boolean.valueOf(this.curRow.getBoolean(index));
            case 17 -> this.curRow.getLocalDate(index);
            case 18 -> this.curRow.getLocalTime(index);
            case 11 -> this.curRow.getInstant(index);
            case 12, 15 -> this.curRow.getUuid(index);
            case 16 -> this.curRow.getInetAddress(index);
            case 33 -> new CasMapValue(executionContext, this.columnDefinitions.get(index).getKeyspace().toString(), (Map)this.curRow.getObject(index), (MapType)type.getType());
            case 32 -> {
                ListType listType = (ListType)type.getType();
                yield new CasListValue(((CasSession)this.getSession()).getProgressMonitor(), executionContext, this.columnDefinitions.get(index).getKeyspace().toString(), (List)this.curRow.getObject(index), listType);
            }
            case 34 -> {
                SetType setType = (SetType)type.getType();
                yield new CasSetValue(executionContext, this.columnDefinitions.get(index).getKeyspace().toString(), (Collection)this.curRow.getObject(index), setType);
            }
            case 49 -> new CasTupleValue(executionContext, this.columnDefinitions.get(index).getKeyspace().toString(), this.curRow.getTupleValue(index));
            case 48 -> new CasUDTValue(executionContext, this.columnDefinitions.get(index).getKeyspace().toString(), this.curRow.getUdtValue(index));
            default -> {
                DataType var5_7 = type.getType();
                if (var5_7 instanceof VectorType) {
                    VectorType vectorType = (VectorType)var5_7;
                    yield new CasVectorValue(executionContext, this.columnDefinitions.get(index).getKeyspace().toString(), (CqlVector<? extends Number>)((CqlVector)this.curRow.getObject(index)), vectorType);
                }
                yield new DBContentByteBuffer((DBCExecutionContext)executionContext, this.curRow.getByteBuffer(index));
            }
        };
    }

    public static GenericType<Object> getClassFromType(DataType dataType) {
        TypeCodec codec = CodecRegistry.DEFAULT.codecFor(dataType);
        return codec.getJavaType();
    }

    public Object getAttributeValue(String name) throws DBCException {
        if (this.curRow == null) {
            throw new DBCException("You have to fetch a row");
        }
        if (this.curRow.isNull(name)) {
            return null;
        }
        ColumnDefinition def = this.columnDefinitions.get(name);
        return switch (def.getType().getProtocolCode()) {
            case 1, 13 -> this.curRow.getString(name);
            case 20 -> this.curRow.getByte(name);
            case 19 -> this.curRow.getShort(name);
            case 9 -> this.curRow.getInt(name);
            case 2, 5 -> this.curRow.getLong(name);
            case 14 -> this.curRow.getBigInteger(name);
            case 6 -> this.curRow.getBigDecimal(name);
            case 8 -> Float.valueOf(this.curRow.getFloat(name));
            case 7 -> this.curRow.getDouble(name);
            case 4 -> this.curRow.getBoolean(name);
            case 18 -> this.curRow.getLocalTime(name);
            case 17 -> this.curRow.getLocalDate(name);
            case 11 -> this.curRow.getInstant(name);
            case 12, 15 -> this.curRow.getUuid(name);
            case 16 -> this.curRow.getInetAddress(name);
            case 33 -> this.curRow.getMap(name, CasResultSet.getClassFromType(((MapType)def.getType()).getKeyType()).getRawType(), CasResultSet.getClassFromType(((MapType)def.getType()).getValueType()).getRawType());
            case 32 -> this.curRow.getList(name, CasResultSet.getClassFromType(((ListType)def.getType()).getElementType()).getClass());
            case 34 -> this.curRow.getSet(name, CasResultSet.getClassFromType(((SetType)def.getType()).getElementType()).getClass());
            case 49 -> this.curRow.getTupleValue(name);
            case 48 -> this.curRow.getUdtValue(name);
            default -> this.curRow.getByteBuffer(name);
        };
    }

    private Class<?> toJavaClass(DataType dataType) {
        switch (dataType.getProtocolCode()) {
            case 13: {
                return String.class;
            }
            case 9: {
                return Integer.class;
            }
            case 2: {
                return Long.class;
            }
        }
        throw new IllegalArgumentException("Unsupported data type: " + String.valueOf(dataType));
    }

    public boolean nextRow() {
        if (!this.rowIterator.hasNext()) {
            this.curRow = null;
            this.columnDefinitions = null;
            return false;
        }
        this.curRow = this.rowIterator.next();
        this.columnDefinitions = this.curRow.getColumnDefinitions();
        ++this.rowCount;
        return true;
    }

    public boolean moveTo(int position) {
        this.rowIterator = this.resultSet.currentPage().iterator();
        if (position > 0) {
            int i = 0;
            while (i < position && this.rowIterator.hasNext()) {
                this.rowIterator.next();
                ++i;
            }
        }
        return true;
    }

    @NotNull
    public CasResultSetMetaData getMeta() {
        if (this.metaData == null) {
            this.metaData = new CasResultSetMetaData((CasBaseStatement)this.statement, this.resultSet);
        }
        return this.metaData;
    }

    public void close() {
        if (((CasSession)((CasBaseStatement)this.statement).getSession()).isLoggingEnabled()) {
            QMUtils.getDefaultHandler().handleResultSetClose((DBCResultSet)this, this.rowCount);
        }
    }

    public DBCTrace getExecutionTrace() {
        return new CasQueryTrace(this.resultSet.getExecutionInfo());
    }
}

