/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.cosmos.nosql;

import com.azure.core.credential.TokenCredential;
import com.azure.cosmos.CosmosAsyncClient;
import com.azure.cosmos.CosmosClientBuilder;
import com.dbeaver.db.cosmos.nosql.DCosmosDataSourceInfo;
import com.dbeaver.db.cosmos.nosql.DCosmosDatabase;
import com.dbeaver.db.cosmos.nosql.DCosmosNoSQLExecutionContext;
import com.dbeaver.db.cosmos.nosql.DCosmosSQLDialect;
import com.dbeaver.model.NoSQLDataSource;
import com.dbeaver.model.NoSQLDialect;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourceInfo;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.access.DBAAuthCredentials;
import org.jkiss.dbeaver.model.access.DBAAuthModel;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.cache.BasicObjectCache;

public class DCosmosNoSQLDataSource
extends NoSQLDataSource<DCosmosNoSQLExecutionContext>
implements DBPRefreshableObject {
    private static final Log log = Log.getLog(DCosmosNoSQLDataSource.class);
    @NotNull
    private volatile CosmosAsyncClient client;
    @NotNull
    private final DDatabaseCache cache = new DDatabaseCache();

    public DCosmosNoSQLDataSource(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSourceContainer container) throws DBException {
        super(container);
        this.executionContext = new DCosmosNoSQLExecutionContext(this, "Main Cosmos DB for NoSQL Connection", null);
        ((DCosmosNoSQLExecutionContext)this.executionContext).connect(monitor);
        this.client = this.buildClient(monitor, container.getActualConnectionConfiguration());
    }

    @Nullable
    public DCosmosDatabase getCachedDatabase(@NotNull DBRProgressMonitor monitor, @NotNull String id) throws DBException {
        return (DCosmosDatabase)this.cache.getObject(monitor, (DBSObject)this, id);
    }

    @NotNull
    public Collection<DCosmosDatabase> getDatabases(@NotNull DBRProgressMonitor monitor) {
        try {
            return this.cache.getAllObjects(monitor, this);
        }
        catch (DBException e) {
            log.error((Object)"Error reading databases", (Throwable)e);
            return Collections.emptyList();
        }
    }

    @NotNull
    public DCosmosNoSQLExecutionContext openIsolatedContext(@NotNull DBRProgressMonitor monitor, @NotNull String purpose, @Nullable DBCExecutionContext initFrom) throws DBException {
        String selectedDatabase = initFrom instanceof DCosmosNoSQLExecutionContext ? ((DCosmosNoSQLExecutionContext)initFrom).getSelectedDatabase() : null;
        DCosmosNoSQLExecutionContext context = new DCosmosNoSQLExecutionContext(this, purpose, selectedDatabase);
        context.connect(monitor);
        return context;
    }

    public void shutdown(@NotNull DBRProgressMonitor monitor) {
        super.shutdown(monitor);
        this.client.close();
    }

    @NotNull
    public DBPDataSourceInfo getInfo() {
        return new DCosmosDataSourceInfo();
    }

    @NotNull
    public NoSQLDialect getSQLDialect() {
        return new DCosmosSQLDialect();
    }

    public void initialize(@NotNull DBRProgressMonitor monitor) throws DBException {
    }

    public Collection<? extends DBSObject> getChildren(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.getDatabases(monitor);
    }

    @Nullable
    public DCosmosDatabase getChild(@NotNull DBRProgressMonitor monitor, @NotNull String childName) throws DBException {
        return this.getCachedDatabase(monitor, childName);
    }

    @NotNull
    public Class<? extends DBSObject> getPrimaryChildType(@Nullable DBRProgressMonitor monitor) throws DBException {
        return DCosmosDatabase.class;
    }

    public void cacheStructure(@NotNull DBRProgressMonitor monitor, int scope) throws DBException {
    }

    @NotNull
    public CosmosAsyncClient getClient() {
        return this.client;
    }

    @Nullable
    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        this.cache.clearCache();
        return this;
    }

    public void recreateClient(DBRProgressMonitor monitor) throws DBException {
        this.client.close();
        this.client = this.buildClient(monitor, this.container.getActualConnectionConfiguration());
    }

    private CosmosAsyncClient buildClient(DBRProgressMonitor monitor, DBPConnectionConfiguration configuration) throws DBException {
        Properties connectProps = new Properties();
        DBAAuthModel authModel = configuration.getAuthModel();
        DBAAuthCredentials crd = authModel.loadCredentials(this.container, configuration);
        authModel.initAuthentication(monitor, (DBPDataSource)this, crd, configuration, connectProps);
        String endpoint = configuration.getServerName();
        if (connectProps.containsKey("accessToken")) {
            return new CosmosClientBuilder().endpoint(endpoint).credential((TokenCredential)connectProps.get("accessToken")).buildAsyncClient();
        }
        if (connectProps.containsKey("key")) {
            return new CosmosClientBuilder().endpoint(endpoint).key((String)connectProps.get("key")).buildAsyncClient();
        }
        throw new DBCException("No valid authentication credentials provided for Cosmos DB connection");
    }

    private static class DDatabaseCache
    extends BasicObjectCache<DCosmosNoSQLDataSource, DCosmosDatabase> {
        private DDatabaseCache() {
        }

        @NotNull
        public Collection<DCosmosDatabase> getAllObjects(@NotNull DBRProgressMonitor monitor, @Nullable DCosmosNoSQLDataSource dataSource) throws DBException {
            if (!this.isFullyCached() && !monitor.isForceCacheUsage()) {
                this.loadObjects(monitor, dataSource);
            }
            return this.getCachedObjects();
        }

        private void loadObjects(DBRProgressMonitor monitor, DCosmosNoSQLDataSource dataSource) {
            if (this.isFullyCached() || monitor.isCanceled()) {
                return;
            }
            List<DCosmosDatabase> databases = Objects.requireNonNull((List)dataSource.getClient().readAllDatabases().collectList().block()).stream().map(db -> new DCosmosDatabase(db.getId(), dataSource)).toList();
            this.setCache(databases);
        }
    }
}

