/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.couchbase3.exec;

import com.dbeaver.db.couchbase3.exec.CouchbaseExecutionContext;
import com.dbeaver.db.couchbase3.exec.CouchbaseQueryStatement;
import com.dbeaver.db.couchbase3.model.CouchbaseDataSource;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.exec.DBCStatementType;
import org.jkiss.dbeaver.model.impl.AbstractSession;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;

public class CouchbaseSession
extends AbstractSession {
    private static final Log log = Log.getLog(CouchbaseSession.class);
    private final CouchbaseExecutionContext executionContext;

    public CouchbaseSession(DBRProgressMonitor monitor, DBCExecutionPurpose purpose, String taskTitle, CouchbaseExecutionContext executionContext) {
        super(monitor, purpose, taskTitle);
        this.executionContext = executionContext;
    }

    @NotNull
    public CouchbaseExecutionContext getExecutionContext() {
        return this.executionContext;
    }

    @NotNull
    public CouchbaseDataSource getDataSource() {
        return (CouchbaseDataSource)this.executionContext.getDataSource();
    }

    @NotNull
    public DBCStatement prepareStatement(@NotNull DBCStatementType type, @NotNull String query, boolean scrollable, boolean updatable, boolean returnGeneratedKeys) throws DBCException {
        return new CouchbaseQueryStatement(this, this.getExecutionContext().getCluster(), query);
    }

    public void cancelBlock(@NotNull DBRProgressMonitor monitor, @Nullable Thread blockThread) throws DBException {
        if (blockThread != null) {
            blockThread.interrupt();
        }
    }

    public void close() {
        super.close();
    }
}

