/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.couchbase3.model;

import com.dbeaver.model.NoSQLDialect;
import java.util.Arrays;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPIdentifierCase;
import org.jkiss.dbeaver.model.DBPKeywordType;
import org.jkiss.dbeaver.model.data.DBDDataFilter;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.parser.SQLSemanticProcessor;
import org.jkiss.utils.Pair;

public class CouchbaseSQLDialect
extends NoSQLDialect {
    public static final CouchbaseSQLDialect INSTANCE = new CouchbaseSQLDialect();
    public static final String[][] DEFAULT_IDENTIFIER_QUOTES = new String[][]{{"`", "`"}};
    public static final Pair<String, String> IN_CLAUSE_PARENTHESES = new Pair((Object)"[", (Object)"]");

    public CouchbaseSQLDialect() {
        this.addKeywords(Arrays.asList("limit", "offset"), DBPKeywordType.KEYWORD);
    }

    @NotNull
    public Pair<String, String> getInClauseParentheses() {
        return IN_CLAUSE_PARENTHESES;
    }

    @NotNull
    public String getDialectId() {
        return "couchbase3";
    }

    @NotNull
    public String getDialectName() {
        return "Couchbase 5+";
    }

    @NotNull
    public DBPIdentifierCase storesUnquotedCase() {
        return DBPIdentifierCase.MIXED;
    }

    @NotNull
    public String addFiltersToQuery(@Nullable DBRProgressMonitor monitor, @NotNull DBPDataSource dataSource, @NotNull String query, @NotNull DBDDataFilter filter) throws DBException {
        return SQLSemanticProcessor.injectFiltersToQuery((DBRProgressMonitor)monitor, (DBPDataSource)dataSource, (String)query, (DBDDataFilter)filter);
    }

    @NotNull
    public String[][] getIdentifierQuoteStrings() {
        return DEFAULT_IDENTIFIER_QUOTES;
    }

    public boolean validIdentifierStart(char c) {
        return super.validIdentifierStart(c) || c == '_';
    }

    public boolean supportsAliasInSelect() {
        return false;
    }

    public boolean supportsAliasInUpdate() {
        return false;
    }

    public boolean supportsSubqueries() {
        return false;
    }
}

