/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.dsql.model;

import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.postgresql.PostgreDataSourceProvider;
import org.jkiss.dbeaver.ext.postgresql.PostgreUtils;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataSource;
import org.jkiss.dbeaver.ext.postgresql.model.impls.PostgreServerType;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourceURLProvider;
import org.jkiss.dbeaver.model.DatabaseURL;
import org.jkiss.dbeaver.model.access.DBAAuthModel;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.connection.DBPDriverConfigurationType;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.CommonUtils;

public class DSQLDataSourceProvider
extends PostgreDataSourceProvider {
    public DBPDataSource openDataSource(DBRProgressMonitor monitor, DBPDataSourceContainer container) throws DBException {
        return new PostgreDataSource(monitor, container);
    }

    public String getConnectionURL(DBPDriver driver, DBPConnectionConfiguration connectionInfo) {
        DBPDataSourceURLProvider sourceURLProvider;
        String connectionURL;
        DBAAuthModel authModel;
        DBPConnectionConfiguration configToUse = connectionInfo;
        String databaseName = connectionInfo.getDatabaseName();
        if (databaseName != null && databaseName.contains("/")) {
            configToUse = new DBPConnectionConfiguration(connectionInfo);
            configToUse.setDatabaseName(databaseName.replace("/", "%2F"));
        }
        if ((authModel = configToUse.getAuthModel()) instanceof DBPDataSourceURLProvider && CommonUtils.isNotEmpty((String)(connectionURL = (sourceURLProvider = (DBPDataSourceURLProvider)authModel).getConnectionURL(driver, configToUse)))) {
            return connectionURL;
        }
        if (configToUse.getConfigurationType() == DBPDriverConfigurationType.URL) {
            return configToUse.getUrl();
        }
        PostgreServerType serverType = PostgreUtils.getServerType((DBPDriver)driver);
        if (serverType.supportsCustomConnectionURL()) {
            return DatabaseURL.generateUrlByTemplate((DBPDriver)driver, (DBPConnectionConfiguration)configToUse);
        }
        StringBuilder url = new StringBuilder("jdbc:postgresql://");
        url.append(configToUse.getHostName());
        if (!CommonUtils.isEmpty((String)configToUse.getHostPort())) {
            url.append(":").append(configToUse.getHostPort());
        }
        url.append("/");
        if (!CommonUtils.isEmpty((String)configToUse.getDatabaseName())) {
            url.append(configToUse.getDatabaseName());
        }
        return url.toString();
    }
}

