/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.google.firestore;

import com.dbeaver.db.google.firestore.data.FireStoreDocument;
import com.dbeaver.db.google.firestore.model.FireStoreDatasource;
import com.dbeaver.model.document.data.DBMapValue;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import net.sf.jsqlparser.expression.DateValue;
import net.sf.jsqlparser.expression.DoubleValue;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.LongValue;
import net.sf.jsqlparser.expression.StringValue;
import net.sf.jsqlparser.expression.TimestampValue;
import net.sf.jsqlparser.expression.operators.relational.ParenthesedExpressionList;
import net.sf.jsqlparser.schema.Column;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.sql.SQLConstants;
import org.jkiss.dbeaver.model.sql.SQLUtils;

public class FirestoreUtils {
    public static Map<String, Object> unwrapMapValue(DBMapValue<FireStoreDatasource> value) {
        return FirestoreUtils.unwrapPlainMap(value.getRawValue());
    }

    private static Map<String, Object> unwrapPlainMap(Map<String, Object> value) {
        LinkedHashMap<String, Object> dbObject = new LinkedHashMap<String, Object>();
        if (value != null) {
            for (Map.Entry<String, Object> me : value.entrySet()) {
                dbObject.put(me.getKey(), FirestoreUtils.unwrapPlainValue(me.getValue()));
            }
        }
        return dbObject;
    }

    private static List<Object> unwrapPlainList(List<?> value) {
        ArrayList<Object> dbObject = new ArrayList<Object>();
        for (Object item : value) {
            dbObject.add(FirestoreUtils.unwrapPlainValue(item));
        }
        return dbObject;
    }

    public static Object unwrapPlainValue(Object value) {
        if (value instanceof FireStoreDocument) {
            return FirestoreUtils.unwrapMapValue((DBMapValue<FireStoreDatasource>)((FireStoreDocument)((Object)value)).getRootNode());
        }
        if (value instanceof DBMapValue) {
            return FirestoreUtils.unwrapMapValue((DBMapValue<FireStoreDatasource>)((DBMapValue)value));
        }
        if (value instanceof Map) {
            return FirestoreUtils.unwrapPlainMap((Map)value);
        }
        if (value instanceof List) {
            return FirestoreUtils.unwrapPlainList((List)value);
        }
        return value;
    }

    public static Object convertValueExpressionToObject(Expression expression) throws DBCException {
        ParenthesedExpressionList parenthesis;
        if (expression instanceof StringValue) {
            return ((StringValue)expression).getValue();
        }
        if (expression instanceof LongValue) {
            return ((LongValue)expression).getValue();
        }
        if (expression instanceof DoubleValue) {
            return ((DoubleValue)expression).getValue();
        }
        if (expression instanceof ParenthesedExpressionList && (parenthesis = (ParenthesedExpressionList)expression).size() == 1) {
            return FirestoreUtils.convertValueExpressionToObject((Expression)parenthesis.get(0));
        }
        if (expression instanceof DateValue) {
            return ((DateValue)expression).getValue();
        }
        if (expression instanceof TimestampValue) {
            return ((TimestampValue)expression).getValue();
        }
        if (expression instanceof Column) {
            String string = expression.toString();
            if (string.equalsIgnoreCase(Boolean.TRUE.toString())) {
                return Boolean.TRUE;
            }
            if (string.equalsIgnoreCase(Boolean.FALSE.toString())) {
                return Boolean.FALSE;
            }
            return string;
        }
        return expression.toString();
    }

    public static String unquote(String name) {
        CharSequence[] attrNameParts = SQLUtils.splitFullIdentifier((String)name, (String)".", (String[][])SQLConstants.DOUBLE_QUOTE_STRINGS, (boolean)false);
        return String.join((CharSequence)".", attrNameParts);
    }

    public static String extractCollectionPathFromFullyQualifiedName(@NotNull String fullyQualifiedName) throws DBCException {
        StringJoiner joiner = new StringJoiner("/");
        char[] array = new char[fullyQualifiedName.length()];
        fullyQualifiedName.getChars(0, fullyQualifiedName.length(), array, 0);
        QuotingState state = QuotingState.NON_QUOTED;
        StringBuilder word = new StringBuilder();
        int i = 0;
        while (i < array.length) {
            char c = array[i];
            if (!Character.isWhitespace(c) || state == QuotingState.QUOTED || state == QuotingState.QUOTE_ESCAPED) {
                if (c == '\"' && state == QuotingState.QUOTED) {
                    state = array.length > i + 1 && array[i + 1] == '\"' ? QuotingState.QUOTE_ESCAPED : QuotingState.LEFT_QUOTES;
                } else if (c == '\"' && state == QuotingState.NON_QUOTED) {
                    state = QuotingState.QUOTED;
                } else if (c == '.' && (state == QuotingState.NON_QUOTED || state == QuotingState.LEFT_QUOTES)) {
                    state = QuotingState.NON_QUOTED;
                    joiner.add(word);
                    word = new StringBuilder();
                } else {
                    if (state == QuotingState.LEFT_QUOTES) {
                        throw new DBCException("Invalid fully-qualified name");
                    }
                    if (state == QuotingState.QUOTE_ESCAPED) {
                        state = QuotingState.QUOTED;
                    }
                    word.append(c);
                }
            }
            ++i;
        }
        if (!word.isEmpty()) {
            if (state == QuotingState.NON_QUOTED || state == QuotingState.LEFT_QUOTES) {
                joiner.add(word);
            } else {
                throw new DBCException("Can't parse value");
            }
        }
        return joiner.toString();
    }

    public static Map<String, Object> enrichDocumentMapWithProperties(Map<String, Object> docMap, String docId, String path) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("__name__", docId);
        result.putAll(docMap);
        return result;
    }

    public static Map<String, Object> cleanupDocumentMapProperties(Map<String, Object> docMap) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>(docMap);
        result.remove("__name__");
        return result;
    }

    private static enum QuotingState {
        NON_QUOTED,
        QUOTED,
        QUOTE_ESCAPED,
        LEFT_QUOTES;

    }
}

