/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.google.firestore.exec;

import com.dbeaver.db.google.firestore.data.FireStoreResultSet;
import com.dbeaver.db.google.firestore.exec.FireStoreSession;
import com.dbeaver.model.document.exec.DocumentReadStatement;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.qm.QMUtils;
import org.jkiss.dbeaver.model.runtime.DBRBlockingObject;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;

public abstract class FireStoreBaseStatement
extends DocumentReadStatement<FireStoreSession> {
    private final String query;
    private int updateRowCount = -1;
    protected int limit;
    protected int offset;
    protected int timeout = 20;
    protected Object result = null;
    private int fetchSize;
    private Throwable executeError;

    public FireStoreBaseStatement(FireStoreSession session, String query) {
        super((DBCSession)session);
        this.query = query;
    }

    @NotNull
    public String getQueryString() {
        return this.query;
    }

    public void setLimit(long offset, long limit) throws DBCException {
        this.limit = (int)limit;
        this.offset = (int)offset;
    }

    public int getResultsFetchSize() {
        return this.fetchSize;
    }

    public void setResultsFetchSize(int fetchSize) throws DBCException {
        this.fetchSize = fetchSize;
    }

    @Nullable
    public Throwable[] getStatementWarnings() throws DBCException {
        return null;
    }

    public void setStatementTimeout(int timeout) throws DBCException {
        this.timeout = timeout;
    }

    @Nullable
    public FireStoreResultSet openResultSet() throws DBCException {
        Object object = this.result;
        if (object instanceof List) {
            List list = (List)object;
            return new FireStoreResultSet(this, list);
        }
        return new FireStoreResultSet(this, (Long)this.result);
    }

    public long getUpdateRowCount() {
        return this.updateRowCount;
    }

    public void setUpdateRowCount(int updateRowCount) {
        this.updateRowCount = updateRowCount;
    }

    public void cancelBlock(@NotNull DBRProgressMonitor monitor, @Nullable Thread blockThread) throws DBException {
        if (blockThread != null) {
            blockThread.interrupt();
        }
    }

    public boolean nextResults() throws DBCException {
        return false;
    }

    public boolean hasResultSet() {
        return this.result != null;
    }

    protected void beforeExecute() {
        this.executeError = null;
        if (((FireStoreSession)this.getSession()).isLoggingEnabled()) {
            QMUtils.getDefaultHandler().handleStatementExecuteBegin((DBCStatement)this);
        }
        this.startBlock();
    }

    protected void startBlock() {
        ((FireStoreSession)this.getSession()).getProgressMonitor().startBlock((DBRBlockingObject)this, null);
    }

    protected void afterExecute() {
        this.endBlock();
        if (((FireStoreSession)this.getSession()).isLoggingEnabled()) {
            QMUtils.getDefaultHandler().handleStatementExecuteEnd((DBCStatement)this, this.getUpdateRowCount(), this.executeError);
        }
    }

    protected void endBlock() {
        ((FireStoreSession)this.getSession()).getProgressMonitor().endBlock();
    }

    protected DBCException handleExecuteError(Throwable ex) {
        this.executeError = ex;
        if (ex instanceof DBCException) {
            return (DBCException)ex;
        }
        return new DBCException(ex, (DBCExecutionContext)((FireStoreSession)this.getSession()).getExecutionContext());
    }
}

