/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.influxdb;

import com.dbeaver.ee.influxdb.model.InfluxDataSource;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourceProvider;
import org.jkiss.dbeaver.model.app.DBPPlatform;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.preferences.DBPPropertyDescriptor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.CommonUtils;

public class InfluxDataSourceProvider
implements DBPDataSourceProvider {
    private static final Log log = Log.getLog(InfluxDataSourceProvider.class);

    public void init(@NotNull DBPPlatform platform) {
    }

    public long getFeatures() {
        return 2L;
    }

    @NotNull
    public DBPPropertyDescriptor[] getConnectionProperties(@NotNull DBRProgressMonitor monitor, @NotNull DBPDriver driver, @NotNull DBPConnectionConfiguration connectionInfo) throws DBException {
        return null;
    }

    @NotNull
    public String getConnectionURL(@NotNull DBPDriver driver, @NotNull DBPConnectionConfiguration connectionInfo) {
        boolean useSSL = CommonUtils.getBoolean((String)connectionInfo.getProviderProperty("@dbeaver-influxdb.use.ssl"), (boolean)false);
        StringBuilder url = new StringBuilder();
        if (useSSL) {
            url.append("https");
        } else {
            url.append("http");
        }
        url.append("://").append(connectionInfo.getHostName()).append(":").append(connectionInfo.getHostPort()).append("/");
        return url.toString();
    }

    @NotNull
    public DBPDataSource openDataSource(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSourceContainer container) throws DBException {
        return new InfluxDataSource(monitor, container);
    }
}

