/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.mongodb.auth;

import com.dbeaver.db.mongodb.auth.MGAuthModelCredentials;
import java.util.Properties;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.impl.auth.AuthModelDatabaseNative;
import org.jkiss.dbeaver.model.impl.auth.AuthModelDatabaseNativeCredentials;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.CommonUtils;

public class MGAuthModelDefault
extends AuthModelDatabaseNative<MGAuthModelCredentials> {
    public static final String ID = "mongodb_default";

    @NotNull
    public MGAuthModelCredentials createCredentials() {
        return new MGAuthModelCredentials();
    }

    @NotNull
    public MGAuthModelCredentials loadCredentials(@NotNull DBPDataSourceContainer dataSource, @NotNull DBPConnectionConfiguration configuration) {
        MGAuthModelCredentials credentials = (MGAuthModelCredentials)super.loadCredentials(dataSource, configuration);
        String mechanism = configuration.getProviderProperty("authMechanism");
        if (CommonUtils.isEmpty((String)mechanism)) {
            mechanism = configuration.getProviderProperty("@dbeaver-mongo-cred-mechanism@");
        }
        if (CommonUtils.isEmpty((String)mechanism)) {
            mechanism = "NONE";
        }
        credentials.setMechanism(mechanism);
        String authSource = configuration.getProviderProperty("authSource");
        if (CommonUtils.isEmpty((String)authSource)) {
            authSource = configuration.getAuthProperty("@dbeaver-auth-source@");
        }
        credentials.setSourceDatabase(authSource);
        super.loadCredentials(dataSource, configuration);
        return credentials;
    }

    public void saveCredentials(@NotNull DBPDataSourceContainer dataSource, @NotNull DBPConnectionConfiguration configuration, @NotNull MGAuthModelCredentials credentials) {
        configuration.setProviderProperty("authMechanism", credentials.getMechanism());
        configuration.setProviderProperty("authSource", credentials.getSourceDatabase());
        super.saveCredentials(dataSource, configuration, (AuthModelDatabaseNativeCredentials)credentials);
    }

    public Object initAuthentication(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSource dataSource, @NotNull MGAuthModelCredentials credentials, @NotNull DBPConnectionConfiguration configuration, @NotNull Properties connProperties) throws DBException {
        return super.initAuthentication(monitor, dataSource, (AuthModelDatabaseNativeCredentials)credentials, configuration, connProperties);
    }

    public void endAuthentication(@NotNull DBPDataSourceContainer dataSource, @NotNull DBPConnectionConfiguration configuration, @NotNull Properties connProperties) {
        super.endAuthentication(dataSource, configuration, connProperties);
    }
}

