/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.mongodb.edit;

import com.dbeaver.db.mongodb.exec.MGSession;
import com.dbeaver.db.mongodb.model.MGCollection;
import com.dbeaver.db.mongodb.model.MGDataSource;
import com.dbeaver.db.mongodb.model.MGDatabase;
import com.mongodb.MongoNamespace;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.CreateCollectionOptions;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEObjectRenamer;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.impl.edit.DirectDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.cache.DBSObjectCache;

public class MongoCollectionManager
extends SQLObjectEditor<MGCollection, MGDatabase>
implements DBEObjectRenamer<MGCollection> {
    public long getMakerOptions(@NotNull DBPDataSource dataSource) {
        return 1L;
    }

    @Nullable
    public DBSObjectCache<? extends DBSObject, MGCollection> getObjectsCache(MGCollection object) {
        return object.getDatabase().getCollectionCache();
    }

    protected MGCollection createDatabaseObject(@NotNull DBRProgressMonitor monitor, @NotNull DBECommandContext context, Object container, Object copyFrom, @NotNull Map<String, Object> options) {
        return new MGCollection((MGDatabase)container, "NewCollection", false);
    }

    protected void addObjectCreateActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actions, final @NotNull SQLObjectEditor.ObjectCreateCommand command, @NotNull Map<String, Object> options) {
        actions.add((DBEPersistAction)new DirectDatabasePersistAction("Create collection"){

            public void afterExecute(DBCSession session, Throwable error) throws DBCException {
                MGCollection collection = (MGCollection)command.getObject();
                CreateCollectionOptions colOptions = new CreateCollectionOptions();
                collection.getDatabase().getDatabase((MGSession)session).createCollection(collection.getName(), colOptions);
            }
        });
    }

    protected void addObjectDeleteActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actions, final @NotNull SQLObjectEditor.ObjectDeleteCommand command, @NotNull Map<String, Object> options) {
        actions.add((DBEPersistAction)new DirectDatabasePersistAction("Drop collection " + ((MGCollection)command.getObject()).getFullyQualifiedName(DBPEvaluationContext.UI)){

            public void afterExecute(DBCSession session, Throwable error) throws DBCException {
                MGCollection collection = (MGCollection)command.getObject();
                collection.getMongoCollection((MGSession)session).drop();
            }
        });
    }

    public void renameObject(@NotNull DBECommandContext commandContext, @NotNull MGCollection object, @NotNull Map<String, Object> options, @NotNull String newName) throws DBException {
        this.processObjectRename(commandContext, (DBSObject)object, options, newName);
    }

    public boolean canRenameObject(MGCollection object) {
        return ((MGDataSource)object.getDataSource()).supportsCollectionRename();
    }

    protected void addObjectRenameActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actions, final @NotNull SQLObjectEditor.ObjectRenameCommand command, @NotNull Map<String, Object> options) {
        actions.add((DBEPersistAction)new DirectDatabasePersistAction("Rename collection"){

            public void afterExecute(DBCSession session, Throwable error) throws DBCException {
                MGCollection collection = (MGCollection)command.getObject();
                MGSession mongoSession = (MGSession)session;
                MongoCollection mongoCollection = collection.getDatabase().getDatabase(mongoSession).getCollection(command.getOldName());
                mongoCollection.renameCollection(new MongoNamespace(collection.getDatabase().getName(), command.getNewName()));
            }
        });
    }
}

