/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.mongodb.exec.js;

import com.dbeaver.db.mongodb.exec.js.MongoJSCollection;
import com.dbeaver.db.mongodb.exec.js.MongoJSProcessor;
import com.dbeaver.db.mongodb.exec.js.MongoJSUtils;
import com.dbeaver.db.mongodb.model.MGDatabase;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.client.ClientSession;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.MongoIterable;
import java.util.List;
import java.util.Map;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.meta.RuntimeAction;
import org.jkiss.utils.CommonUtils;

public class MongoJSDatabase {
    private static final Log log = Log.getLog(MongoJSDatabase.class);
    private final MongoJSProcessor processor;
    private final MGDatabase database;

    public MongoJSDatabase(MongoJSProcessor processor, MGDatabase database) {
        this.processor = processor;
        this.database = database;
    }

    public MongoJSProcessor getProcessor() {
        return this.processor;
    }

    public MGDatabase getDatabase() {
        return this.database;
    }

    @RuntimeAction
    public Object getCollection(Object key) throws DBCException {
        MongoCollection collection = this.database.getDatabase(this.processor.getSession()).getCollection(CommonUtils.toString((Object)key));
        return new MongoJSCollection(this, (MongoCollection<Document>)collection);
    }

    @RuntimeAction
    public Object getMongo() {
        return this.processor.getJsClient();
    }

    @RuntimeAction
    public void createCollection(@NotNull String name) throws DBCException {
        this.database.getDatabase(this.processor.getSession()).createCollection(name);
    }

    @RuntimeAction
    public List<DBObject> listCommands() throws DBCException {
        return (List)this.runCommand("listCommands").get("commands");
    }

    @RuntimeAction
    public Map<String, Object> runCommand(String command) throws DBCException {
        return this.runCommand(Map.of(command, 1));
    }

    @RuntimeAction
    public Map<String, Object> runCommand(Map<String, Object> command) throws DBCException {
        ClientSession clientSession = this.processor.getSession().getClientSession();
        if (clientSession == null) {
            return this.database.getDatabase(this.processor.getSession()).runCommand((Bson)MongoJSUtils.createBasicDocument(command));
        }
        return this.getDatabase().getDatabase(this.processor.getSession()).runCommand(this.processor.getSession().getClientSession(), (Bson)MongoJSUtils.createBasicDocument(command));
    }

    @RuntimeAction
    public Map<String, Object> adminCommand(String command) throws DBCException {
        ClientSession clientSession = this.processor.getSession().getClientSession();
        if (clientSession == null) {
            return this.database.getDataSource().getAdminDatabase(this.processor.getSession()).runCommand((Bson)new BasicDBObject(command, (Object)1));
        }
        MongoDatabase adminDatabase = this.database.getDataSource().getAdminDatabase(this.processor.getSession());
        return adminDatabase.runCommand(this.processor.getSession().getClientSession(), (Bson)new Document(command, (Object)1));
    }

    @RuntimeAction
    public Map<String, Object> help() throws DBCException {
        return this.runCommand("help");
    }

    @RuntimeAction
    public Map<String, Object> commandHelp(String command) throws DBCException {
        return this.runCommand(Map.of("commandHelp", command));
    }

    @RuntimeAction
    public MongoIterable<String> getCollectionNames() throws DBCException {
        MongoDatabase adminDatabase = this.database.getDatabase(this.processor.getSession());
        return adminDatabase.listCollectionNames();
    }

    @RuntimeAction
    public Map<String, Object> currentOp() throws DBCException {
        return this.adminCommand("currentOp");
    }

    @RuntimeAction
    public Map<String, Object> stats() throws DBCException {
        return this.runCommand("dbStats");
    }

    @RuntimeAction
    public Object eval(String script) throws DBCException {
        MongoDatabase db = this.database.getDatabase(this.processor.getSession());
        return db.runCommand((Bson)new BasicDBObject("eval", (Object)script));
    }

    @NotNull
    private MongoDatabase getAdminDatabase() throws DBCException {
        ClientSession clientSession = this.processor.getSession().getClientSession();
        if (clientSession == null) {
            throw new DBCException("Mongo session is not supported");
        }
        return this.getDatabase().getDataSource().getAdminDatabase(this.processor.getSession());
    }

    @NotNull
    public Map<String, Object> createUser(@NotNull Object userObj, @Nullable Object writeConcernObj) throws DBCException {
        if (userObj instanceof Map) {
            String[] knownFields;
            Integer digestPassword;
            Map userData = (Map)MongoJSUtils.unwrapObject(userObj);
            Object userName = userData.get("user");
            BasicDBObject createUserCommand = new BasicDBObject("createUser", userName);
            Object passwordDigestor = userData.get("passwordDigestor");
            Integer n = !(passwordDigestor instanceof String) ? null : (digestPassword = Integer.valueOf(passwordDigestor.equals("server") ? 1 : 0));
            if (writeConcernObj != null) {
                createUserCommand.append("writeConcern", writeConcernObj);
            }
            if (digestPassword != null) {
                createUserCommand.append("digestPassword", (Object)digestPassword);
            }
            String[] stringArray = knownFields = new String[]{"pwd", "customData", "roles", "authenticationRestrictions", "mechanisms"};
            int n2 = knownFields.length;
            int n3 = 0;
            while (n3 < n2) {
                String key = stringArray[n3];
                Object value = userData.get(key);
                if (value != null) {
                    createUserCommand.append(key, value);
                }
                ++n3;
            }
            return this.getDatabase().getDatabase(this.processor.getSession()).runCommand((Bson)createUserCommand);
        }
        throw new DBCException("Invalid argument for createUser command");
    }

    @NotNull
    public Map<String, Object> createUser(@NotNull Object userObj) throws DBCException {
        return this.createUser(userObj, null);
    }
}

