/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.mongodb.exec.js;

import org.jkiss.dbeaver.Log;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Wrapper;

public record MongoJSSafeScriptableProxy(Scriptable scriptable) implements Scriptable,
Wrapper
{
    private static final Log log = Log.getLog(MongoJSSafeScriptableProxy.class);

    public String getClassName() {
        return this.scriptable.getClassName();
    }

    public Object get(String name, Scriptable start) {
        boolean forbiddenMethodName;
        boolean bl = forbiddenMethodName = "getClass".equals(name) || "class".equals(name);
        if (forbiddenMethodName) {
            log.warn((Object)("Forbidden method " + name + " is called in MongoDB JS script."));
            return Scriptable.NOT_FOUND;
        }
        return this.scriptable.get(name, start);
    }

    public Object get(int index, Scriptable start) {
        return this.scriptable.get(index, start);
    }

    public boolean has(String name, Scriptable start) {
        return this.scriptable.has(name, start);
    }

    public boolean has(int index, Scriptable start) {
        return this.scriptable.has(index, start);
    }

    public void put(String name, Scriptable start, Object value) {
        this.scriptable.put(name, start, value);
    }

    public void put(int index, Scriptable start, Object value) {
        this.scriptable.put(index, start, value);
    }

    public void delete(String name) {
        this.scriptable.delete(name);
    }

    public void delete(int index) {
        this.scriptable.delete(index);
    }

    public Scriptable getPrototype() {
        return this.scriptable.getPrototype();
    }

    public void setPrototype(Scriptable prototype) {
        this.scriptable.setPrototype(prototype);
    }

    public Scriptable getParentScope() {
        return this.scriptable.getParentScope();
    }

    public void setParentScope(Scriptable parent) {
        this.scriptable.setParentScope(parent);
    }

    public Object[] getIds() {
        return this.scriptable.getIds();
    }

    public Object getDefaultValue(Class<?> hint) {
        return this.scriptable.getDefaultValue(hint);
    }

    public boolean hasInstance(Scriptable instance) {
        return this.scriptable.hasInstance(instance);
    }

    public Object unwrap() {
        Scriptable scriptable = this.scriptable;
        if (scriptable instanceof Wrapper) {
            Wrapper wrapper = (Wrapper)scriptable;
            return wrapper.unwrap();
        }
        return this.scriptable;
    }
}

