/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.mongodb.model;

import com.dbeaver.db.mongodb.model.MGCollection;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.impl.DBObjectNameCaseTransformer;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableColumn;

public abstract class MGCollectionAttribute
implements DBSTableColumn {
    private final MGCollection table;
    private String name;
    private int position;

    public MGCollectionAttribute(MGCollection table, String name, int position) {
        this.table = table;
        this.name = name;
        this.position = position;
    }

    @NotNull
    public DBPDataSource getDataSource() {
        return this.table.getDataSource();
    }

    @Property(viewable=true, editable=true, valueTransformer=DBObjectNameCaseTransformer.class, order=1)
    @NotNull
    public String getName() {
        return this.name;
    }

    public boolean isPersisted() {
        return true;
    }

    public int getOrdinalPosition() {
        return this.position;
    }

    @NotNull
    public MGCollection getParentObject() {
        return this.table;
    }

    public String getDefaultValue() {
        return null;
    }

    public String getDescription() {
        return null;
    }

    @NotNull
    public String getFullTypeName() {
        return DBUtils.getFullTypeName((DBSTypedObject)this);
    }

    public Integer getScale() {
        return 0;
    }

    @Nullable
    public Integer getPrecision() {
        return 0;
    }

    public long getMaxLength() {
        return 0L;
    }

    public long getTypeModifiers() {
        return 0L;
    }

    public String toString() {
        return DBUtils.getFullQualifiedName((DBPDataSource)this.getDataSource(), (DBPNamedObject[])new DBPNamedObject[]{this.table, this});
    }
}

