/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.mongodb.model;

import com.dbeaver.db.mongodb.data.handlers.MongoObjectValueHandler;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Date;
import org.bson.BsonTimestamp;
import org.bson.types.Binary;
import org.bson.types.Decimal128;
import org.bson.types.ObjectId;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.data.json.JSONUtils;
import org.jkiss.utils.Base64;

public class MGTypeConverters {

    public static class BsonTimestampConverter
    extends TypeAdapter<BsonTimestamp>
    implements JsonSerializer<BsonTimestamp>,
    JsonDeserializer<BsonTimestamp> {
        public JsonElement serialize(BsonTimestamp src, Type srcType, JsonSerializationContext context) {
            return new JsonPrimitive(JSONUtils.formatISODate((Date)BsonTimestampConverter.getDate(src)));
        }

        public BsonTimestamp deserialize(JsonElement json, Type type, JsonDeserializationContext context) throws JsonParseException {
            Date date = JSONUtils.parseDate((Object)json.getAsString());
            return date == null ? null : new BsonTimestamp(date.getTime());
        }

        public void write(JsonWriter jsonWriter, BsonTimestamp date) throws IOException {
            if (date == null) {
                jsonWriter.nullValue();
            } else {
                jsonWriter.jsonValue(JSONUtils.formatISODate((Date)BsonTimestampConverter.getDate(date)));
            }
        }

        @NotNull
        private static Date getDate(BsonTimestamp date) {
            return new Date((long)date.getTime() * 1000L);
        }

        public BsonTimestamp read(JsonReader jsonReader) throws IOException {
            throw new IOException("Unsupported operation");
        }
    }

    public static class Decimal128TypeConverter
    extends TypeAdapter<Decimal128> {
        public void write(JsonWriter jsonWriter, Decimal128 decimal128) throws IOException {
            jsonWriter.jsonValue(decimal128.toString());
        }

        public Decimal128 read(JsonReader jsonReader) throws IOException {
            throw new IOException("Unsupported operation");
        }
    }

    public static class ISODateTypeConverter
    extends TypeAdapter<Date>
    implements JsonSerializer<Date>,
    JsonDeserializer<Date> {
        public JsonElement serialize(Date src, Type srcType, JsonSerializationContext context) {
            return new JsonPrimitive(JSONUtils.formatISODate((Date)src));
        }

        public Date deserialize(JsonElement json, Type type, JsonDeserializationContext context) throws JsonParseException {
            return JSONUtils.parseDate((Object)json.getAsString());
        }

        public void write(JsonWriter jsonWriter, Date date) throws IOException {
            if (date == null) {
                jsonWriter.nullValue();
            } else {
                jsonWriter.jsonValue(JSONUtils.formatISODate((Date)date));
            }
        }

        public Date read(JsonReader jsonReader) throws IOException {
            throw new IOException("Unsupported operation");
        }
    }

    public static class ObjectIdTypeAdapter
    extends TypeAdapter<ObjectId> {
        public static final ObjectIdTypeAdapter INSTANCE = new ObjectIdTypeAdapter();

        public void write(JsonWriter jsonWriter, ObjectId objectId) throws IOException {
            jsonWriter.jsonValue("ObjectId(\"" + objectId.toString() + "\")");
        }

        public ObjectId read(JsonReader jsonReader) throws IOException {
            throw new IOException("Unsupported operation");
        }
    }

    public static class UUIDTypeAdapter
    extends TypeAdapter<Binary> {
        public static final UUIDTypeAdapter INSTANCE = new UUIDTypeAdapter();

        public void write(JsonWriter out, Binary value) throws IOException {
            switch (value.getType()) {
                case 3: 
                case 4: {
                    out.jsonValue("UUID(\"" + String.valueOf(MongoObjectValueHandler.fromStandardBinaryUUID(value)) + "\")");
                    break;
                }
                default: {
                    String subtype = Integer.toHexString(value.getType());
                    String base64 = Base64.encode((byte[])value.getData());
                    out.jsonValue("{ \"$binary\": { \"subType\": \"" + subtype + "\", \"base64\": \"" + base64 + "\" } }");
                }
            }
        }

        public Binary read(JsonReader in) throws IOException {
            throw new IOException("Unsupported operation");
        }
    }
}

