/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.netezza.edit;

import com.dbeaver.db.netezza.model.NetezzaGenericTable;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.generic.edit.GenericTableManager;
import org.jkiss.dbeaver.ext.generic.model.GenericSchema;
import org.jkiss.dbeaver.ext.generic.model.GenericTableBase;
import org.jkiss.dbeaver.ext.generic.model.GenericTableColumn;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEObjectRenamer;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.CommonUtils;

public class NetezzaGenericTableManager
extends GenericTableManager
implements DBEObjectRenamer<GenericTableBase> {
    protected void appendTableModifiers(DBRProgressMonitor monitor, GenericTableBase tableBase, SQLObjectEditor.NestedObjectCommand tableProps, StringBuilder ddl, boolean alter, Map<String, Object> options) throws DBException {
        if (tableBase instanceof NetezzaGenericTable) {
            NetezzaGenericTable table = (NetezzaGenericTable)tableBase;
            try {
                NetezzaGenericTable.AdditionalInfo additionalInfo = table.getAdditionalInfo(monitor);
                Object distr = additionalInfo.getDistributeOn() != null && !additionalInfo.getDistributeOn().equals("RANDOM") ? "\nDISTRIBUTE ON HASH (" + additionalInfo.getDistributeOn() + ")" : "\nDISTRIBUTE ON RANDOM";
                ddl.append((String)distr);
                Object organize = "";
                if (additionalInfo.getOrganizedOn() != null) {
                    organize = "\nORGANIZE ON (" + additionalInfo.getOrganizedOn() + ")";
                }
                ddl.append((String)organize).append(";");
            }
            catch (DBException e) {
                log.error((Object)e);
            }
        } else {
            super.appendTableModifiers(monitor, (DBSEntity)tableBase, tableProps, ddl, alter, options);
        }
    }

    protected void addObjectExtraActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actions, @NotNull SQLObjectEditor.NestedObjectCommand<GenericTableBase, SQLObjectEditor.PropertyHandler> command, @NotNull Map<String, Object> options) {
        GenericTableBase tableBase = (GenericTableBase)command.getObject();
        if (command.hasProperty((Object)"description") || (CommonUtils.getOption(options, (String)"ddl.includeComments") || CommonUtils.getOption(options, (String)"script.format.compact")) && tableBase.getDescription() != null) {
            actions.add((DBEPersistAction)new SQLDatabasePersistAction("Comment table", "COMMENT ON TABLE " + tableBase.getFullyQualifiedName(DBPEvaluationContext.DDL) + " IS " + SQLUtils.quoteString((DBSObject)tableBase, (String)CommonUtils.notEmpty((String)tableBase.getDescription()))));
        }
        if (CommonUtils.getOption(options, (String)"ddl.includeComments") || !tableBase.isPersisted()) {
            try {
                List columns = tableBase.getAttributes(monitor);
                if (columns != null) {
                    for (GenericTableColumn column : columns) {
                        StringBuilder script = new StringBuilder();
                        if (column.getDescription() == null) continue;
                        script.append("COMMENT ON COLUMN ").append(tableBase.getFullyQualifiedName(DBPEvaluationContext.DDL)).append(".").append(column.getName()).append(" IS '").append(SQLUtils.escapeString((DBPDataSource)column.getDataSource(), (String)column.getDescription())).append("';");
                        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Comment table", script.toString()));
                    }
                }
            }
            catch (DBException e) {
                e.printStackTrace();
            }
        }
    }

    protected void addObjectRenameActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actions, @NotNull SQLObjectEditor.ObjectRenameCommand command, @NotNull Map<String, Object> options) {
        GenericTableBase tableBase = (GenericTableBase)command.getObject();
        GenericSchema schema = tableBase.getSchema();
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Rename synonym", "ALTER TABLE " + DBUtils.getQuotedIdentifier((DBSObject)tableBase.getCatalog()) + "." + DBUtils.getQuotedIdentifier((DBSObject)schema) + "." + DBUtils.getQuotedIdentifier((DBPDataSource)tableBase.getDataSource(), (String)command.getOldName()) + " RENAME TO " + DBUtils.getQuotedIdentifier((DBSObject)schema) + "." + DBUtils.getQuotedIdentifier((DBPDataSource)tableBase.getDataSource(), (String)command.getNewName())));
    }

    public void renameObject(@NotNull DBECommandContext commandContext, @NotNull GenericTableBase object, @NotNull Map<String, Object> options, @NotNull String newName) throws DBException {
        this.processObjectRename(commandContext, (DBSObject)object, options, newName);
    }
}

