/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.netezza.model;

import com.dbeaver.db.netezza.model.NetezzaSourceObject;
import java.sql.ResultSet;
import java.util.Date;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.generic.model.GenericSchema;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.ext.generic.model.GenericSynonym;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPQualifiedObject;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.meta.PropertyLength;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class NetezzaGenericSynonym
extends GenericSynonym
implements DBPQualifiedObject,
NetezzaSourceObject {
    private String description;
    private String databaseName;
    private String schemaName;
    private Date createDate;
    private String owner;
    private String targetObjectSchema;
    private String targetObjectName;
    private String source;

    public NetezzaGenericSynonym(@NotNull GenericStructContainer container, String name, String targetObjectSchema, String targetObjectName, @Nullable String description, @NotNull JDBCResultSet dbResult) {
        super(container, name, description);
        this.description = description;
        this.targetObjectSchema = targetObjectSchema;
        this.targetObjectName = targetObjectName;
        this.databaseName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"DATABASE");
        this.schemaName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"SCHEMA");
        this.createDate = JDBCUtils.safeGetTimestamp((ResultSet)dbResult, (String)"CREATEDATE");
        this.owner = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"OWNER");
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    @Property(viewable=true, order=2)
    public String getOwner() {
        return this.owner;
    }

    @Property(viewable=true, order=3)
    public Date getCreateDate() {
        return this.createDate;
    }

    @Property(viewable=true, order=21)
    public GenericSchema getTargetObjectSchema(DBRProgressMonitor monitor) throws DBException {
        return this.getParentObject().getCatalog().getSchema(monitor, this.targetObjectSchema);
    }

    @Property(viewable=true, order=22)
    public DBSObject getTargetObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        GenericSchema schema = this.getTargetObjectSchema(monitor);
        return schema == null ? null : schema.getChild(monitor, this.targetObjectName);
    }

    @Property(viewable=true, updatable=true, editable=true, length=PropertyLength.MULTILINE, order=10)
    @Nullable
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public void setObjectDefinitionText(String sourceText) throws DBException {
        this.source = sourceText;
    }

    @NotNull
    public String getObjectDefinitionText(@NotNull DBRProgressMonitor monitor, @NotNull Map<String, Object> options) throws DBException {
        if (this.source == null) {
            this.source = "CREATE SYNONYM " + this.getFullyQualifiedName(DBPEvaluationContext.DML) + " FOR " + this.targetObjectName;
        }
        return this.source;
    }
}

