/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.oracle.edit;

import com.dbeaver.db.oracle.model.OracleTableExt;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.oracle.edit.OracleTableManager;
import org.jkiss.dbeaver.ext.oracle.model.OracleSchema;
import org.jkiss.dbeaver.ext.oracle.model.OracleTable;
import org.jkiss.dbeaver.ext.oracle.model.OracleTableColumn;
import org.jkiss.dbeaver.ext.oracle.model.OracleTablePartition;
import org.jkiss.dbeaver.ext.oracle.model.OracleTablePhysical;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.impl.jdbc.struct.JDBCTableColumn;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.CommonUtils;

public class OracleTableManagerExt
extends OracleTableManager {
    protected OracleTable createDatabaseObject(@NotNull DBRProgressMonitor monitor, @NotNull DBECommandContext context, Object container, Object copyFrom, @NotNull Map<String, Object> options) {
        OracleSchema schema = (OracleSchema)container;
        OracleTableExt table = new OracleTableExt(schema, "NEW_TABLE");
        this.setNewObjectName(monitor, (DBSObject)schema, (DBSObject)table);
        return table;
    }

    protected void appendTableModifiers(DBRProgressMonitor monitor, OracleTable table, SQLObjectEditor.NestedObjectCommand tableProps, StringBuilder ddl, boolean alter, Map<String, Object> options) throws DBException {
        if (!table.isPersisted()) {
            String partitionedBy = table.getPartitionedBy(monitor);
            if (CommonUtils.isNotEmpty((String)partitionedBy)) {
                this.addPartitionsToScript(table, ddl, partitionedBy, alter, OracleTableManagerExt.getDelimiter(options));
            } else if (CommonUtils.isEmpty((String)partitionedBy) && !table.getCachedPartitions().isEmpty()) {
                throw new DBException("Can't create partitioning without key columns. Please specify column name(s) in the Partition Keys field.");
            }
        }
        super.appendTableModifiers(monitor, table, tableProps, ddl, alter, options);
    }

    private void addPartitionsToScript(OracleTable table, StringBuilder ddl, String partitionedBy, boolean alter, String delimiter) throws DBException {
        String subPartitionedBy;
        this.findKeysByColumnNames(table, partitionedBy, table.getPartitionKeys());
        if (CommonUtils.isEmpty((Collection)table.getPartitionKeys())) {
            throw new DBException("Can't create partitioning without key columns. Please check column names added as partition keys.");
        }
        Collection partitions = table.getCachedPartitions();
        if (CommonUtils.isEmpty((Collection)partitions)) {
            throw new DBException("Can't create partitioning without partitions. Create partitions first.");
        }
        OracleTablePhysical.PartitionInfo partitionInfo = table.getPartitionInfo();
        this.addMainPartitioning(ddl, partitionInfo, table.getPartitionKeys(), false, delimiter);
        if (CommonUtils.isNotEmpty((String)partitionInfo.getPartitionByIntervalExpr()) && !alter) {
            ddl.append(" INTERVAL (").append(partitionInfo.getPartitionByIntervalExpr()).append(")");
        }
        if (CommonUtils.isNotEmpty((String)(subPartitionedBy = table.getSubPartitionedBy()))) {
            this.findKeysByColumnNames(table, subPartitionedBy, table.getSubPartitionKeys());
            if (!CommonUtils.isEmpty((Collection)table.getSubPartitionKeys())) {
                this.addMainPartitioning(ddl, partitionInfo, table.getSubPartitionKeys(), true, delimiter);
            } else {
                throw new DBException("Can't create subpartitioning without subpartitions. Create subpartitions first.");
            }
        }
        ddl.append(" (");
        boolean isFirst = true;
        for (OracleTablePartition partition : partitions) {
            if (partition.isSubPartition()) continue;
            if (!isFirst) {
                ddl.append(",");
            } else {
                isFirst = false;
            }
            this.addPartitionPart(ddl, partitionInfo, partition, false, delimiter);
            List subPartitions = partition.getCachedSubPartitions();
            if (CommonUtils.isEmpty((Collection)subPartitions)) continue;
            ddl.append(" (");
            isFirst = true;
            for (OracleTablePartition subPartition : subPartitions) {
                if (!isFirst) {
                    ddl.append(",");
                } else {
                    isFirst = false;
                }
                this.addPartitionPart(ddl, partitionInfo, subPartition, true, delimiter);
            }
            ddl.append(")");
        }
        ddl.append(")");
    }

    private void addPartitionPart(@NotNull StringBuilder ddl, @Nullable OracleTablePhysical.PartitionInfo partitionInfo, @NotNull OracleTablePartition partition, boolean isSubPartition, String delimiter) {
        ddl.append(delimiter).append(isSubPartition ? "SUB" : "").append("PARTITION ").append(DBUtils.getQuotedIdentifier((DBSObject)partition)).append(" VALUES ").append(partitionInfo != null && (isSubPartition ? partitionInfo.getSubpartitionType() : partitionInfo.getPartitionType()) == OracleTablePartition.PartitionType.RANGE ? "LESS THAN " : "").append("(").append(partition.getValuesForCreating()).append(")");
    }

    private void addMainPartitioning(@NotNull StringBuilder ddl, @Nullable OracleTablePhysical.PartitionInfo partitionInfo, @NotNull Set<OracleTableColumn> partitionKeys, boolean isSubPartition, String delimiter) {
        ddl.append(delimiter).append(isSubPartition ? "SUB" : "").append("PARTITION BY ");
        if (partitionInfo != null) {
            ddl.append(isSubPartition ? (partitionInfo.getSubpartitionType() != OracleTablePartition.PartitionType.NONE ? partitionInfo.getSubpartitionType().name() : "RANGE") : partitionInfo.getPartitionType().name());
        } else {
            ddl.append("RANGE");
        }
        String keyNames = partitionKeys.stream().map(JDBCTableColumn::getName).collect(Collectors.joining(",", "(", ")"));
        ddl.append(" ").append(keyNames);
    }

    private void findKeysByColumnNames(@NotNull OracleTable table, @Nullable String value, @NotNull Set<OracleTableColumn> keysList) {
        List cachedAttributes;
        String columnsToParse;
        if (CommonUtils.isNotEmpty((String)value) && CommonUtils.isNotEmpty((String)(columnsToParse = value.trim())) && !CommonUtils.isEmpty((Collection)(cachedAttributes = table.getCachedAttributes()))) {
            if (columnsToParse.contains(",")) {
                String[] strings;
                String[] stringArray = strings = columnsToParse.split(",");
                int n = strings.length;
                int n2 = 0;
                while (n2 < n) {
                    String string = stringArray[n2];
                    if (CommonUtils.isNotEmpty((String)string)) {
                        this.findCachedColumnByName(table, keysList, cachedAttributes, string.trim());
                    }
                    ++n2;
                }
            } else {
                this.findCachedColumnByName(table, keysList, cachedAttributes, columnsToParse);
            }
        }
    }

    private void findCachedColumnByName(@NotNull OracleTable table, @NotNull Set<OracleTableColumn> keysList, @NotNull List<? extends OracleTableColumn> cachedAttributes, @NotNull String string) {
        OracleTableColumn column = cachedAttributes.stream().filter(e -> e.getName().equalsIgnoreCase(string)).findFirst().orElse(null);
        if (column == null) {
            log.warn((Object)("Column '" + string + "' not found in table '" + table.getFullyQualifiedName(DBPEvaluationContext.DDL) + "'"));
        } else {
            keysList.add(column);
        }
    }
}

