/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.oracle.model.data.gis;

import java.lang.reflect.Array;
import java.util.AbstractList;

public class SDOAttributeList
extends AbstractList {
    final Object ARRAY;
    final int OFFSET;
    final int LEN;
    final int SIZE;
    final int START;
    final int END;
    final int STEP;

    public SDOAttributeList(Object array) {
        this(array, 0, 1);
    }

    public SDOAttributeList(Object array, int offset, int len) {
        this(array, offset, len, 0, Array.getLength(array));
    }

    public SDOAttributeList(Object array, int offset, int len, int start, int end) {
        this.START = start;
        this.END = end;
        this.ARRAY = array;
        this.OFFSET = offset;
        this.LEN = len;
        this.SIZE = Math.abs(this.START - this.END) / this.LEN;
        int n = this.STEP = this.START < this.END ? this.LEN : -this.LEN;
        if (!this.ARRAY.getClass().isArray()) {
            throw new IllegalArgumentException("Provided argument was not an array");
        }
        if (Array.getLength(this.ARRAY) % this.LEN != 0) {
            throw new IllegalArgumentException("You have requested SDOCoordinates of " + this.LEN + " ordinates. This is inconsistent with an array of length " + Array.getLength(this.ARRAY));
        }
    }

    @Override
    public Object get(int index) {
        this.rangeCheck(index);
        return Array.get(this.ARRAY, this.START + this.STEP * index + this.OFFSET);
    }

    public double getDouble(int index) {
        this.rangeCheck(index);
        return Array.getDouble(this.ARRAY, this.START + this.STEP * index + this.OFFSET);
    }

    public String getString(int index) {
        this.rangeCheck(index);
        return Array.get(this.ARRAY, this.START + this.STEP * index + this.OFFSET).toString();
    }

    public double[] toDoubleArray() {
        double[] array = new double[this.size()];
        int i = 0;
        while (i < this.size()) {
            array[i] = this.getDouble(i);
            ++i;
        }
        return array;
    }

    public Object[] toObjectArray() {
        Object[] array = new Object[this.size()];
        int i = 0;
        while (i < this.size()) {
            array[i] = this.get(i);
            ++i;
        }
        return array;
    }

    private void rangeCheck(int index) {
        if (index >= this.SIZE) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.SIZE);
        }
    }

    @Override
    public int size() {
        return this.SIZE;
    }
}

