/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.redis.exec;

import com.dbeaver.db.redis.exec.RedisSession;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionSource;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.impl.AbstractStatement;
import org.jkiss.dbeaver.model.qm.QMUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import redis.clients.jedis.JedisPooled;
import redis.clients.jedis.UnifiedJedis;

public abstract class RedisBaseStatement
extends AbstractStatement<RedisSession> {
    private static final Log log = Log.getLog(RedisBaseStatement.class);
    protected String query;
    protected DBCExecutionSource source;
    protected Throwable executeError;
    protected long offset;
    protected long limit;
    protected long updateCount = -1L;

    protected RedisBaseStatement(RedisSession session, String query) {
        this(session, query, 0L, 0L);
    }

    protected RedisBaseStatement(RedisSession session, String query, long firstRow, long maxRows) {
        super((DBCSession)session);
        this.query = query;
        this.offset = firstRow;
        this.limit = maxRows;
        if (session.isLoggingEnabled()) {
            QMUtils.getDefaultHandler().handleStatementOpen((DBCStatement)this);
        }
    }

    @NotNull
    public <T> T getCommands(Class<T> cmdClass) {
        return ((RedisSession)this.getSession()).getCommands(cmdClass);
    }

    public String getQueryString() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public DBCExecutionSource getStatementSource() {
        return this.source;
    }

    public void setStatementSource(@Nullable DBCExecutionSource source) {
        this.source = source;
    }

    public long getUpdateRowCount() {
        return this.updateCount;
    }

    public boolean nextResults() {
        this.updateCount = -1L;
        return false;
    }

    public void setLimit(long offset, long limit) throws DBCException {
        this.offset = offset;
        this.limit = limit;
    }

    @Nullable
    public Throwable[] getStatementWarnings() throws DBCException {
        return null;
    }

    public void cancelBlock(@NotNull DBRProgressMonitor monitor, @Nullable Thread blockThread) throws DBException {
        UnifiedJedis jedisClient = ((RedisSession)this.getSession()).getJedisClient();
        if (!(jedisClient instanceof JedisPooled)) {
            throw new DBException("Redis command cancel not implemented");
        }
        ((JedisPooled)jedisClient).close();
    }

    public void setStatementTimeout(int timeout) throws DBCException {
    }

    public void setResultsFetchSize(int fetchSize) throws DBCException {
    }

    public long getOffset() {
        return this.offset;
    }

    public long getLimit() {
        return this.limit;
    }

    protected DBCException handleExecuteError(Throwable ex) {
        this.executeError = ex;
        if (ex instanceof DBCException) {
            return (DBCException)ex;
        }
        return new DBCException(ex, (DBCExecutionContext)((RedisSession)this.getSession()).getExecutionContext());
    }

    protected String getClusterSampleKey() {
        return "";
    }
}

