/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.redshift.model;

import com.dbeaver.db.redshift.RedshiftUtils;
import com.dbeaver.db.redshift.model.RedshiftDatabase;
import com.dbeaver.db.redshift.model.RedshiftSessionManager;
import com.dbeaver.db.redshift.model.RedshiftSharedDatabase;
import com.dbeaver.db.redshift.model.RedshiftUserPasswordManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.postgresql.PostgreUtils;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreCharset;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataSource;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDatabase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgrePrivilegeType;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreRole;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTablespace;
import org.jkiss.dbeaver.ext.postgresql.model.impls.PostgreServerType;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.access.DBAUserPasswordManager;
import org.jkiss.dbeaver.model.admin.sessions.DBAServerSessionManager;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectFilter;
import org.jkiss.dbeaver.model.struct.cache.SimpleObjectCache;
import org.jkiss.utils.CommonUtils;

public class RedshiftDataSource
extends PostgreDataSource {
    private static final Log log = Log.getLog(RedshiftDataSource.class);
    private static final PostgrePrivilegeType[] SUPPORTED_PRIVILEGE_TYPES = new PostgrePrivilegeType[]{PostgrePrivilegeType.SELECT, PostgrePrivilegeType.INSERT, PostgrePrivilegeType.UPDATE, PostgrePrivilegeType.DELETE, PostgrePrivilegeType.REFERENCES, PostgrePrivilegeType.CREATE, PostgrePrivilegeType.TEMPORARY, PostgrePrivilegeType.USAGE, PostgrePrivilegeType.RULE, PostgrePrivilegeType.EXECUTE};
    private boolean supportsRedshiftDatashare;
    private final SimpleObjectCache<RedshiftDataSource, RedshiftSharedDatabase> sharedDatabases = new SimpleObjectCache();

    public RedshiftDataSource(DBRProgressMonitor monitor, DBPDataSourceContainer container) throws DBException {
        super(monitor, container);
    }

    public PostgreServerType getType() {
        PostgreServerType redshift = RedshiftUtils.getRedshiftServerType();
        if (redshift != null) {
            return redshift;
        }
        return super.getType();
    }

    protected boolean isReadDatabaseList(DBPConnectionConfiguration configuration) {
        return true;
    }

    public boolean supportsRedshiftDatashare() {
        return this.supportsRedshiftDatashare;
    }

    protected PreparedStatement prepareReadDatabaseListStatement(@NotNull DBRProgressMonitor monitor, @NotNull Connection bootstrapConnection, @NotNull DBPConnectionConfiguration configuration) throws SQLException {
        return this.prepareReadDatabaseListStatement(bootstrapConnection, configuration, false);
    }

    private PreparedStatement prepareReadDatabaseListStatement(@NotNull Connection bootstrapConnection, @NotNull DBPConnectionConfiguration configuration, boolean readSharedDatabases) throws SQLException {
        if (!this.supportsRedshiftDatashare) {
            Throwable throwable = null;
            Object var5_6 = null;
            try (Statement dbStat = bootstrapConnection.createStatement();){
                Throwable throwable2 = null;
                Object var8_14 = null;
                try (ResultSet resultSet = dbStat.executeQuery("SELECT 1 FROM pg_catalog.pg_class p\nJOIN pg_catalog.pg_namespace n ON p.relnamespace = n.oid\nWHERE p.relname = 'svv_redshift_databases'\nAND n.nspname = 'pg_catalog'");){
                    this.supportsRedshiftDatashare = resultSet.next();
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        DBSObjectFilter catalogFilters = this.getContainer().getObjectFilter(PostgreDatabase.class, null, false);
        boolean readOnlyDefaultDB = !readSharedDatabases && !CommonUtils.getBoolean((String)configuration.getProviderProperty("@dbeaver-show-non-default-db@"), (boolean)false);
        boolean showTemplates = !readOnlyDefaultDB && CommonUtils.getBoolean((String)configuration.getProviderProperty("@dbeaver-show-template-db@"), (boolean)false);
        boolean showUnavailable = !readOnlyDefaultDB && CommonUtils.getBoolean((String)configuration.getProviderProperty("@dbeaver-show-unavailable-db@"), (boolean)false);
        StringBuilder catalogQuery = new StringBuilder();
        catalogQuery.append("SELECT db.oid,db.*");
        if (this.supportsRedshiftDatashare) {
            catalogQuery.append(",rsdb.database_type,rsdb.database_options");
        }
        catalogQuery.append(" FROM pg_catalog.pg_database db");
        if (this.supportsRedshiftDatashare) {
            catalogQuery.append("\nLEFT JOIN SVV_REDSHIFT_DATABASES rsdb \nON rsdb.database_name=db.datname WHERE (rsdb.database_type ").append(readSharedDatabases ? "=" : "IS NULL OR rsdb.database_type <>").append(" 'shared')");
        } else {
            catalogQuery.append("\nWHERE db.datname <> 'padb_harvest'");
        }
        if (readOnlyDefaultDB) {
            catalogQuery.append(" AND db.datname = ?");
        } else {
            if (!showTemplates) {
                catalogQuery.append(" AND NOT datistemplate");
            }
            if (catalogFilters != null) {
                JDBCUtils.appendFilterClause((StringBuilder)catalogQuery, (DBSObjectFilter)catalogFilters, (String)"datname", (boolean)false);
            }
            catalogQuery.append("\nORDER BY db.datname");
        }
        PreparedStatement dbStat = bootstrapConnection.prepareStatement(catalogQuery.toString());
        if (readOnlyDefaultDB) {
            dbStat.setString(1, PostgreUtils.getDatabaseNameFromConfiguration((DBPConnectionConfiguration)configuration));
        } else if (catalogFilters != null) {
            JDBCUtils.setFilterParameters((PreparedStatement)dbStat, (int)1, (DBSObjectFilter)catalogFilters);
        }
        return dbStat;
    }

    @NotNull
    public PostgreDatabase createDatabaseImpl(@NotNull DBRProgressMonitor monitor, ResultSet dbResult) throws DBException {
        return new RedshiftDatabase(monitor, (PostgreDataSource)this, dbResult);
    }

    @NotNull
    public PostgreDatabase createDatabaseImpl(@NotNull DBRProgressMonitor monitor, String name) throws DBException {
        return new RedshiftDatabase(monitor, (PostgreDataSource)this, name);
    }

    @NotNull
    public PostgreDatabase createDatabaseImpl(DBRProgressMonitor monitor, String name, PostgreRole owner, String templateName, PostgreTablespace tablespace, PostgreCharset encoding) throws DBException {
        return new RedshiftDatabase(monitor, this, name, owner, templateName, tablespace, encoding);
    }

    public void initialize(@NotNull DBRProgressMonitor monitor) throws DBException {
        super.initialize(monitor);
        if (this.supportsRedshiftDatashare) {
            PostgreDatabase defaultInstance = this.getDefaultInstance();
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBPDataSource)this, (String)"Read shared databases");){
                    Throwable throwable2 = null;
                    Object var7_11 = null;
                    try (PreparedStatement dbStat = this.prepareReadDatabaseListStatement((Connection)session, this.getContainer().getActualConnectionConfiguration(), true);){
                        Throwable throwable3 = null;
                        Object var10_16 = null;
                        try (ResultSet dbResult = dbStat.executeQuery();){
                            ArrayList<RedshiftSharedDatabase> dbList = new ArrayList<RedshiftSharedDatabase>();
                            while (dbResult.next()) {
                                RedshiftSharedDatabase sdb = new RedshiftSharedDatabase(this, (RedshiftDatabase)defaultInstance, dbResult);
                                dbList.add(sdb);
                            }
                            this.sharedDatabases.setCache(dbList);
                        }
                        catch (Throwable throwable4) {
                            if (throwable3 == null) {
                                throwable3 = throwable4;
                            } else if (throwable3 != throwable4) {
                                throwable3.addSuppressed(throwable4);
                            }
                            throw throwable3;
                        }
                    }
                    catch (Throwable throwable5) {
                        if (throwable2 == null) {
                            throwable2 = throwable5;
                        } else if (throwable2 != throwable5) {
                            throwable2.addSuppressed(throwable5);
                        }
                        throw throwable2;
                    }
                }
                catch (Throwable throwable6) {
                    if (throwable == null) {
                        throwable = throwable6;
                    } else if (throwable != throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                log.error((Object)"Error reading shared databases", (Throwable)e);
            }
        }
    }

    public List<? extends DBSObject> getChildren(@NotNull DBRProgressMonitor monitor) {
        List<RedshiftSharedDatabase> sharedDatabases;
        List children = super.getChildren(monitor);
        if (this.supportsRedshiftDatashare && !CommonUtils.isEmpty(sharedDatabases = this.getSharedDatabases(monitor))) {
            ArrayList<RedshiftSharedDatabase> mergedChildren = new ArrayList<RedshiftSharedDatabase>(children);
            mergedChildren.addAll(sharedDatabases);
            return mergedChildren;
        }
        return children;
    }

    public DBSObject getChild(@NotNull DBRProgressMonitor monitor, @NotNull String childName) {
        Object child = super.getChild(monitor, childName);
        if (child == null && this.supportsRedshiftDatashare) {
            child = this.getSharedDatabase(monitor, childName);
        }
        return child;
    }

    @Association
    public List<RedshiftSharedDatabase> getSharedDatabases(@NotNull DBRProgressMonitor monitor) {
        return this.sharedDatabases.getAllObjects(monitor, (DBSObject)this);
    }

    public RedshiftSharedDatabase getSharedDatabase(@NotNull DBRProgressMonitor monitor, String name) {
        return (RedshiftSharedDatabase)this.sharedDatabases.getObject(monitor, (DBSObject)this, name);
    }

    @NotNull
    public PostgrePrivilegeType[] getSupportedPrivilegeTypes() {
        return SUPPORTED_PRIVILEGE_TYPES;
    }

    public <T> T getAdapter(@NotNull Class<T> adapter) {
        if (adapter == DBAServerSessionManager.class) {
            return adapter.cast((Object)new RedshiftSessionManager(this));
        }
        if (adapter == DBAUserPasswordManager.class) {
            return adapter.cast(new RedshiftUserPasswordManager(this));
        }
        return (T)super.getAdapter(adapter);
    }
}

