/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.redshift.model;

import com.dbeaver.db.redshift.model.RedshiftDatabase;
import com.dbeaver.db.redshift.model.RedshiftPermissionOwner;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.postgresql.PostgreUtils;
import org.jkiss.dbeaver.ext.postgresql.model.PostgrePrivilegeOwner;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.CommonUtils;

public class RedshiftUser
extends RedshiftPermissionOwner {
    private static final DateTimeFormatter DATE_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private boolean catalogUpdate;

    public RedshiftUser(@NotNull RedshiftDatabase database, @NotNull String name, @NotNull String password) {
        super(database, name, password, true);
    }

    public RedshiftUser(@NotNull RedshiftDatabase database, @NotNull ResultSet dbResult) throws SQLException {
        super(database, dbResult);
    }

    protected void loadInfo(ResultSet dbResult) {
        this.persisted = true;
        this.oid = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"usesysid");
        this.name = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"usename");
        this.superUser = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"usesuper");
        this.createDatabase = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"usecreatedb");
        this.catalogUpdate = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"usecatupd");
        this.connLimit = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"useconnlimit");
        this.password = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"passwd");
        this.validUntil = Optional.ofNullable(JDBCUtils.safeGetTimestamp((ResultSet)dbResult, (String)"valuntil")).map(Timestamp::toLocalDateTime).orElse(null);
        this.canLogin = true;
    }

    @Override
    @Property(editable=true, updatable=true, order=10)
    public boolean isSuperUser() {
        return this.superUser;
    }

    @Override
    @Property(editable=true, updatable=true, order=11)
    public boolean isCreateDatabase() {
        return this.createDatabase;
    }

    @Property(order=12)
    public boolean isCatalogUpdate() {
        return this.catalogUpdate;
    }

    @NotNull
    public String getObjectDefinitionText(@NotNull DBRProgressMonitor monitor, @NotNull Map<String, Object> options) throws DBException {
        StringBuilder ddl = new StringBuilder();
        ddl.append("-- DROP USER ").append(DBUtils.getQuotedIdentifier((DBSObject)this)).append(";\n\n");
        ddl.append("CREATE USER ").append(DBUtils.getQuotedIdentifier((DBSObject)this));
        ddl.append("\n\t").append(this.isCreateDatabase() ? "CREATEDB" : "NOCREATEDB");
        ddl.append("\n\t").append(this.isSuperUser() ? "CREATEUSER" : "NOCREATEUSER");
        ddl.append("\n\tCONNECTION LIMIT ").append(this.getConnLimit() >= 0 ? Integer.valueOf(this.getConnLimit()) : "UNLIMITED");
        if (this.getValidUntil() != null) {
            ddl.append("\n\tVALID UNTIL ").append(SQLUtils.quoteString((DBSObject)this, (String)DATE_FORMAT.format(this.getValidUntil())));
        }
        ddl.append(';');
        if (CommonUtils.getOption(options, (String)"ddl.includePermissions")) {
            ddl.append("\n");
            ArrayList actions = new ArrayList();
            PostgreUtils.getObjectGrantPermissionActions((DBRProgressMonitor)monitor, (PostgrePrivilegeOwner)this, actions, options);
            ddl.append("\n").append(SQLUtils.generateScript((DBPDataSource)this.getDataSource(), (DBEPersistAction[])actions.toArray(new DBEPersistAction[0]), (boolean)false));
        }
        return ddl.toString();
    }
}

