/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.salesforce.ui;

import com.dbeaver.db.salesforce.ui.SalesForceUIMessages;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.access.DBAAuthModel;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.connection.DatabaseNativeAuthModelConfigurator;
import org.jkiss.dbeaver.ui.internal.UIConnectionMessages;
import org.jkiss.utils.CommonUtils;

public class SalesForcePasswordAuthConfigurator
extends DatabaseNativeAuthModelConfigurator {
    private Text authTokenText;

    public void createControl(@NotNull Composite authPanel, DBAAuthModel<?> object, @NotNull Runnable propertyChangeListener) {
        this.usernameLabel = UIUtils.createLabel((Composite)authPanel, (String)UIConnectionMessages.dialog_connection_auth_label_username);
        this.usernameLabel.setLayoutData((Object)new GridData(32));
        this.createUserNameControls(authPanel, propertyChangeListener);
        this.createPasswordControls(authPanel, propertyChangeListener);
        this.authTokenText = UIUtils.createLabelText((Composite)authPanel, (String)SalesForceUIMessages.auth_configurator_token_label, (String)"", (int)0x400800);
        this.authTokenText.setMessage(SalesForceUIMessages.auth_configurator_token_tip);
    }

    public void loadSettings(@NotNull DBPDataSourceContainer dataSource) {
        super.loadSettings(dataSource);
        DBPConnectionConfiguration connectionInfo = dataSource.getConnectionConfiguration();
        if (this.authTokenText != null && !this.authTokenText.isDisposed()) {
            this.authTokenText.setText(CommonUtils.notEmpty((String)connectionInfo.getAuthProperty("auth-token")));
        }
    }

    public void saveSettings(@NotNull DBPDataSourceContainer dataSource) {
        super.saveSettings(dataSource);
        DBPConnectionConfiguration connectionInfo = dataSource.getConnectionConfiguration();
        if (this.authTokenText != null && !this.authTokenText.isDisposed()) {
            connectionInfo.setAuthProperty("auth-token", this.authTokenText.getText().trim());
        }
    }
}

