/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.snowflake.ui.config;

import com.dbeaver.db.snowflake.model.SnowflakeProcedure;
import com.dbeaver.db.snowflake.ui.internal.SnowflakeUIMessages;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ext.generic.model.GenericDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEObjectConfigurator;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedure;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedureType;
import org.jkiss.dbeaver.ui.UITask;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.object.struct.CreateProcedurePage;
import org.jkiss.utils.CommonUtils;

public class SnowflakeProcedureConfigurator
implements DBEObjectConfigurator<SnowflakeProcedure> {
    public SnowflakeProcedure configureObject(@NotNull DBRProgressMonitor monitor, @Nullable DBECommandContext commandContext, @Nullable Object container, final @NotNull SnowflakeProcedure newProcedure, @NotNull Map<String, Object> options) {
        return (SnowflakeProcedure)new UITask<SnowflakeProcedure>(){

            protected SnowflakeProcedure runTask() {
                SnowflakeCreateProcedurePage createProcedurePage = new SnowflakeCreateProcedurePage(newProcedure);
                if (!createProcedurePage.edit()) {
                    return null;
                }
                if (createProcedurePage.getProcedureType() == DBSProcedureType.FUNCTION) {
                    newProcedure.setDbsProcedureType(DBSProcedureType.FUNCTION);
                }
                newProcedure.setName(createProcedurePage.getProcedureName());
                ProcedureLanguages language = createProcedurePage.getProcedureLanguage();
                if (language != null && language != ProcedureLanguages.NONE) {
                    newProcedure.setLanguage(language.name());
                }
                DBSDataType type = createProcedurePage.getReturnDataType();
                newProcedure.setSource("CREATE OR REPLACE " + String.valueOf(createProcedurePage.getProcedureType()) + " " + newProcedure.getFullyQualifiedName(DBPEvaluationContext.DDL) + "()" + (String)(type == null ? "" : "\n\tRETURNS " + type.getFullTypeName()) + (String)(language == null || language == ProcedureLanguages.NONE ? "" : "\n\tLANGUAGE " + language.name()) + "\nAS $$\n\tRETURN 42;\n$$;");
                return newProcedure;
            }
        }.execute();
    }

    private static enum ProcedureLanguages {
        JAVA,
        JAVASCRIPT,
        PYTHON,
        SQL,
        SCALA,
        NONE;

    }

    private static class SnowflakeCreateProcedurePage
    extends CreateProcedurePage {
        private SnowflakeProcedure procedure;
        private ProcedureLanguages procedureLanguage;
        private DBSDataType returnDataType;

        SnowflakeCreateProcedurePage(SnowflakeProcedure procedure) {
            super((DBSProcedure)procedure);
            this.procedure = procedure;
        }

        protected void createExtraControls(Composite group) {
            ProcedureLanguages[] languages = ProcedureLanguages.values();
            Combo languageCombo = UIUtils.createLabelCombo((Composite)group, (String)SnowflakeUIMessages.procedure_configurator_languages_combo, (int)12);
            ProcedureLanguages[] procedureLanguagesArray = languages;
            int n = languages.length;
            int n2 = 0;
            while (n2 < n) {
                ProcedureLanguages lang = procedureLanguagesArray[n2];
                languageCombo.add(lang.name());
                ++n2;
            }
            languageCombo.addModifyListener(e -> {
                int index = languageCombo.getSelectionIndex();
                if (index >= 0) {
                    this.procedureLanguage = languages[index];
                }
            });
            languageCombo.setText(ProcedureLanguages.JAVASCRIPT.name());
            ArrayList<DBSDataType> dataTypes = new ArrayList<DBSDataType>(((GenericDataSource)this.procedure.getDataSource()).getLocalDataTypes());
            dataTypes.sort(Comparator.comparing(DBPNamedObject::getName));
            Combo returnTypeCombo = UIUtils.createLabelCombo((Composite)group, (String)SnowflakeUIMessages.procedure_configurator_return_types_combo, (int)4);
            for (DBSDataType dt : dataTypes) {
                returnTypeCombo.add(dt.getName());
            }
            returnTypeCombo.addModifyListener(e -> {
                String dtName = returnTypeCombo.getText();
                this.returnDataType = !CommonUtils.isEmpty((String)dtName) ? ((GenericDataSource)this.procedure.getDataSource()).getLocalDataType(dtName) : null;
            });
            returnTypeCombo.setText("VARCHAR");
        }

        ProcedureLanguages getProcedureLanguage() {
            return this.procedureLanguage;
        }

        DBSDataType getReturnDataType() {
            return this.returnDataType;
        }
    }
}

