/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.snowflake.model;

import com.dbeaver.db.snowflake.model.SnowflakeSchema;
import com.dbeaver.db.snowflake.model.SnowflakeUtils;
import java.sql.ResultSet;
import java.util.Date;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.generic.model.GenericScriptObject;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPQualifiedObject;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.meta.PropertyLength;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class SnowflakeStream
implements DBSObject,
DBPQualifiedObject,
GenericScriptObject,
DBPRefreshableObject {
    private SnowflakeSchema schema;
    private String name;
    private String streamOwner;
    private String sourceType;
    private String tableName;
    private String baseTables;
    private String type;
    private String stale;
    private String mode;
    private Date created;
    private Date staleAfter;
    private String description;
    private String source;

    SnowflakeStream(@NotNull SnowflakeSchema schema, @NotNull String name, @NotNull JDBCResultSet resultSet) {
        this.schema = schema;
        this.name = name;
        this.streamOwner = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"owner");
        this.sourceType = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"source_type");
        this.tableName = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"table_name");
        this.baseTables = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"baseTables");
        this.type = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"type");
        this.stale = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"stale");
        this.mode = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"mode");
        this.created = JDBCUtils.safeGetTimestamp((ResultSet)resultSet, (String)"created_on");
        this.staleAfter = JDBCUtils.safeGetTimestamp((ResultSet)resultSet, (String)"stale_after");
        this.description = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"comment");
    }

    @Nullable
    public DBSObject getParentObject() {
        return this.schema;
    }

    @Nullable
    public DBPDataSource getDataSource() {
        return this.schema.getDataSource();
    }

    @Property(viewable=true, order=1)
    @NotNull
    public String getName() {
        return this.name;
    }

    @Property(viewable=true, order=2)
    public String getStreamOwner() {
        return this.streamOwner;
    }

    @Property(viewable=true, order=3)
    public String getSourceType() {
        return this.sourceType;
    }

    @Property(viewable=true, order=4)
    public String getTableName() {
        return this.tableName;
    }

    @Property(viewable=true, order=5)
    public String getBaseTables() {
        return this.baseTables;
    }

    @Property(viewable=true, order=6)
    public String getType() {
        return this.type;
    }

    @Property(viewable=true, order=7)
    public String getStale() {
        return this.stale;
    }

    @Property(viewable=true, order=8)
    public String getMode() {
        return this.mode;
    }

    @Property(viewable=true, order=9)
    public Date getCreated() {
        return this.created;
    }

    @Property(viewable=true, order=10)
    public Date getStaleAfter() {
        return this.staleAfter;
    }

    @Property(viewable=true, editable=true, updatable=true, length=PropertyLength.MULTILINE, order=30)
    @Nullable
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String comment) {
        this.description = comment;
    }

    public boolean isPersisted() {
        return true;
    }

    @NotNull
    public String getFullyQualifiedName(@NotNull DBPEvaluationContext context) {
        return this.schema.getCatalog() != null ? DBUtils.getFullQualifiedName((DBPDataSource)this.getDataSource(), (DBPNamedObject[])new DBPNamedObject[]{this.schema.getCatalog(), this.schema, this}) : DBUtils.getFullQualifiedName((DBPDataSource)this.getDataSource(), (DBPNamedObject[])new DBPNamedObject[]{this.schema, this});
    }

    @Nullable
    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) {
        this.source = null;
        return this;
    }

    @NotNull
    public String getObjectDefinitionText(@NotNull DBRProgressMonitor monitor, @NotNull Map<String, Object> options) throws DBException {
        if (this.source == null) {
            this.source = SnowflakeUtils.getObjectDDL(monitor, this, "STREAM", this.description);
        }
        return this.source;
    }
}

