/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.snowflake.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPQualifiedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.CommonUtils;

public class SnowflakeUtils {
    public static String getObjectDDL(@NotNull DBRProgressMonitor monitor, @NotNull DBPQualifiedObject object, @NotNull String objectTypeName, @Nullable String description) throws DBException {
        StringBuilder ddl = new StringBuilder();
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)((DBSObject)object), (String)("Read Snowflake " + objectTypeName + " DDL"));){
                Throwable throwable2 = null;
                Object var9_13 = null;
                try (JDBCPreparedStatement dbStat = session.prepareStatement("SELECT GET_DDL('" + objectTypeName + "', '" + object.getFullyQualifiedName(DBPEvaluationContext.DML) + "', TRUE)");){
                    Throwable throwable3 = null;
                    Object var12_18 = null;
                    try (JDBCResultSet dbResult = dbStat.executeQuery();){
                        if (dbResult.nextRow()) {
                            ddl.append(JDBCUtils.safeGetString((ResultSet)dbResult, (int)1));
                        }
                    }
                    catch (Throwable throwable4) {
                        if (throwable3 == null) {
                            throwable3 = throwable4;
                        } else if (throwable3 != throwable4) {
                            throwable3.addSuppressed(throwable4);
                        }
                        throw throwable3;
                    }
                }
                catch (Throwable throwable5) {
                    if (throwable2 == null) {
                        throwable2 = throwable5;
                    } else if (throwable2 != throwable5) {
                        throwable2.addSuppressed(throwable5);
                    }
                    throw throwable2;
                }
                if (!CommonUtils.isEmpty((String)description)) {
                    ddl.append("\n\nCOMMENT ON ").append(objectTypeName).append(" ").append(object.getFullyQualifiedName(DBPEvaluationContext.DML)).append(" IS ").append(SQLUtils.quoteString((DBSObject)((DBSObject)object), (String)description)).append(";");
                }
                return ddl.toString();
            }
            catch (Throwable throwable6) {
                if (throwable == null) {
                    throwable = throwable6;
                } else if (throwable != throwable6) {
                    throwable.addSuppressed(throwable6);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new DBException("Can't read " + objectTypeName + " DDL from database", (Throwable)e);
        }
    }
}

