/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.sqlite.crypt.ui.views;

import com.dbeaver.db.sqlite.crypt.SQLiteCipherType;
import com.dbeaver.db.sqlite.crypt.SQLiteCryptParam;
import com.dbeaver.db.sqlite.crypt.ui.internal.SQLiteCryptUIActivator;
import com.dbeaver.db.sqlite.crypt.ui.internal.SQLiteCryptUIMessages;
import com.dbeaver.db.sqlite.ui.views.SQLiteExtensionsPage;
import org.eclipse.jface.dialogs.IDialogPage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.ui.IDialogPageProvider;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.CustomTableEditor;
import org.jkiss.dbeaver.ui.controls.TextWithOpenFile;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionPageAbstract;
import org.jkiss.dbeaver.ui.dialogs.connection.DriverPropertiesDialogPage;
import org.jkiss.utils.CommonUtils;

public class SQLiteCryptConnectionPage
extends ConnectionPageAbstract
implements IDialogPageProvider {
    private TextWithOpenFile dbPathText;
    private Combo cipherCombo;
    private Table paramTable;
    private static ImageDescriptor logoImage = SQLiteCryptUIActivator.getImageDescriptor("icons/sqlite_crypt_logo.png");

    public void dispose() {
        super.dispose();
    }

    public void createControl(Composite composite) {
        this.setImageDescriptor(logoImage);
        Composite control = new Composite(composite, 0);
        control.setLayout((Layout)new GridLayout(1, false));
        control.setLayoutData((Object)new GridData(1808));
        ModifyListener textListener = e -> this.site.updateButtons();
        Group mainGroup = UIUtils.createControlGroup((Composite)control, (String)"Settings", (int)4, (int)0, (int)0);
        GridData gd = new GridData(768);
        mainGroup.setLayoutData((Object)gd);
        UIUtils.createControlLabel((Composite)mainGroup, (String)"Path");
        this.dbPathText = new TextWithOpenFile((Composite)mainGroup, "Database file path", new String[]{"*", "*.sqlite", "*.db"});
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        this.dbPathText.setLayoutData((Object)gd);
        this.dbPathText.getTextControl().addModifyListener(textListener);
        this.cipherCombo = UIUtils.createLabelCombo((Composite)mainGroup, (String)"Cipher", (int)12);
        SQLiteCipherType[] sQLiteCipherTypeArray = SQLiteCipherType.values();
        int n = sQLiteCipherTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            SQLiteCipherType ct = sQLiteCipherTypeArray[n2];
            this.cipherCombo.add(ct.getDisplayName());
            ++n2;
        }
        gd = new GridData(32);
        gd.horizontalSpan = 3;
        this.cipherCombo.setLayoutData((Object)gd);
        this.cipherCombo.addModifyListener(textListener);
        this.cipherCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SQLiteCryptConnectionPage.this.updateCipherSelection();
            }
        });
        this.cipherCombo.select(SQLiteCipherType.CHACHA20.ordinal());
        Text dbPasswordText = this.createPasswordText((Composite)mainGroup, SQLiteCryptUIMessages.label_password);
        gd = new GridData(32);
        gd.widthHint = 200;
        dbPasswordText.setLayoutData((Object)gd);
        dbPasswordText.addModifyListener(textListener);
        this.createPasswordControls((Composite)mainGroup, 2);
        Group paramsGroup = UIUtils.createControlGroup((Composite)control, (String)"Cipher parameters", (int)1, (int)0, (int)0);
        paramsGroup.setLayoutData((Object)new GridData(768));
        this.paramTable = new Table((Composite)paramsGroup, 67584);
        UIUtils.createTableColumn((Table)this.paramTable, (int)16384, (String)"Parameter").setWidth(150);
        UIUtils.createTableColumn((Table)this.paramTable, (int)16384, (String)"Value").setWidth(200);
        this.paramTable.setHeaderVisible(true);
        SQLiteCryptParam[] sQLiteCryptParamArray = SQLiteCryptParam.values();
        n2 = sQLiteCryptParamArray.length;
        int n3 = 0;
        while (n3 < n2) {
            SQLiteCryptParam param = sQLiteCryptParamArray[n3];
            TableItem item = new TableItem(this.paramTable, 0);
            item.setData((Object)param);
            item.setText(0, param.name());
            ++n3;
        }
        this.paramTable.setLayoutData((Object)new GridData(768));
        new CustomTableEditor(this.paramTable){

            protected Control createEditor(Table table, int index, TableItem item) {
                if (index != 1) {
                    return null;
                }
                Text text = new Text((Composite)table, 2048);
                text.setText(item.getText(index));
                text.selectAll();
                return text;
            }

            protected void saveEditorValue(Control control, int index, TableItem item) {
                item.setText(index, ((Text)control).getText());
            }
        };
        this.updateCipherSelection();
        this.createDriverPanel(control);
        this.setControl((Control)control);
    }

    private void updateCipherSelection() {
        SQLiteCipherType cipherType = (SQLiteCipherType)CommonUtils.fromOrdinal(SQLiteCipherType.class, (int)this.cipherCombo.getSelectionIndex());
        TableItem[] tableItemArray = this.paramTable.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem paramItem;
            String paramValue = cipherType.getDefaultParameter((SQLiteCryptParam)(paramItem = tableItemArray[n2]).getData());
            paramItem.setText(1, paramValue == null ? "" : paramValue.toString());
            ++n2;
        }
        this.paramTable.setEnabled(cipherType == SQLiteCipherType.CUSTOM);
    }

    public boolean isComplete() {
        return !CommonUtils.isEmpty((String)this.dbPathText.getText());
    }

    public void loadSettings() {
        String cipherName;
        super.loadSettings();
        DBPConnectionConfiguration connectionInfo = this.site.getActiveDataSource().getConnectionConfiguration();
        if (this.dbPathText != null) {
            this.dbPathText.setText(CommonUtils.notEmpty((String)connectionInfo.getDatabaseName()));
        }
        if (this.passwordText != null) {
            this.passwordText.setText(CommonUtils.notEmpty((String)connectionInfo.getUserPassword()));
        }
        if (!CommonUtils.isEmpty((String)(cipherName = connectionInfo.getProviderProperty("cipher")))) {
            this.cipherCombo.select(((SQLiteCipherType)CommonUtils.valueOf(SQLiteCipherType.class, (String)cipherName, (Enum)SQLiteCipherType.CHACHA20)).ordinal());
            this.updateCipherSelection();
        }
        TableItem[] tableItemArray = this.paramTable.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem paramItem = tableItemArray[n2];
            SQLiteCryptParam param = (SQLiteCryptParam)paramItem.getData();
            String paramValue = connectionInfo.getProviderProperty(param.name());
            if (paramValue == null) {
                paramValue = "";
            }
            paramItem.setText(1, paramValue);
            ++n2;
        }
    }

    public void saveSettings(DBPDataSourceContainer dataSource) {
        DBPConnectionConfiguration connectionInfo = dataSource.getConnectionConfiguration();
        if (this.dbPathText != null) {
            connectionInfo.setDatabaseName(this.dbPathText.getText().trim());
        }
        if (this.passwordText != null) {
            connectionInfo.setUserPassword(this.passwordText.getText().trim());
        }
        SQLiteCipherType cipherType = (SQLiteCipherType)CommonUtils.fromOrdinal(SQLiteCipherType.class, (int)this.cipherCombo.getSelectionIndex());
        connectionInfo.setProviderProperty("cipher", cipherType.name());
        TableItem[] tableItemArray = this.paramTable.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem paramItem = tableItemArray[n2];
            String paramName = paramItem.getText(0);
            String paramValue = paramItem.getText(1);
            if (!CommonUtils.isEmpty((String)paramName) && !CommonUtils.isEmpty((String)paramValue)) {
                connectionInfo.setProviderProperty(paramName, paramValue);
            }
            ++n2;
        }
        super.saveSettings(dataSource);
    }

    public IDialogPage[] getDialogPages(boolean extrasOnly, boolean forceCreate) {
        return new IDialogPage[]{new SQLiteExtensionsPage(), new DriverPropertiesDialogPage((ConnectionPageAbstract)this)};
    }
}

