/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.sqlite.ui.views;

import com.dbeaver.db.sqlite.ui.dialog.AttachDatabaseDialog;
import com.dbeaver.db.sqlite.ui.internal.SQLiteUIMessages;
import java.io.File;
import java.util.ArrayList;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionPageAbstract;
import org.jkiss.utils.CommonUtils;

public class SQLiteAttachedDatabasesPage
extends ConnectionPageAbstract {
    private Table attachedDatabasesTable;
    private Button useAttachedDatabases;
    private ToolItem removeItem;
    private ToolItem addItem;

    public SQLiteAttachedDatabasesPage() {
        this.setTitle(SQLiteUIMessages.page_databases_title);
        this.setDescription(SQLiteUIMessages.page_databases_description);
    }

    public boolean isComplete() {
        return true;
    }

    public void createControl(Composite parent) {
        Composite mainComposite = new Composite(parent, 0);
        mainComposite.setLayout((Layout)new GridLayout(1, false));
        mainComposite.setLayoutData((Object)new GridData(1808));
        this.useAttachedDatabases = UIUtils.createCheckbox((Composite)mainComposite, (String)SQLiteUIMessages.page_database_use_attached_databases, (boolean)false);
        this.useAttachedDatabases.setToolTipText(SQLiteUIMessages.page_database_use_attached_databases_tip);
        Composite tableComposite = new Composite(mainComposite, 0);
        tableComposite.setLayout((Layout)new GridLayout(2, false));
        tableComposite.setLayoutData((Object)new GridData(1808));
        this.attachedDatabasesTable = new Table(tableComposite, 2820);
        UIUtils.createTableColumn((Table)this.attachedDatabasesTable, (int)16384, (String)SQLiteUIMessages.page_databases_table_name).setWidth(200);
        UIUtils.createTableColumn((Table)this.attachedDatabasesTable, (int)16384, (String)SQLiteUIMessages.page_databases_table_path).setWidth(200);
        this.attachedDatabasesTable.setHeaderVisible(true);
        this.attachedDatabasesTable.setLayoutData((Object)new GridData(1808));
        ToolBar toolbar = new ToolBar(tableComposite, 512);
        toolbar.setLayoutData((Object)new GridData(2));
        this.addItem = UIUtils.createToolItem((ToolBar)toolbar, (String)SQLiteUIMessages.page_databases_toolbar_attach, (DBPImage)UIIcon.ADD, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AttachDatabaseDialog attachDatabaseDialog = new AttachDatabaseDialog(SQLiteAttachedDatabasesPage.this.getShell());
                if (attachDatabaseDialog.open() != 0) {
                    return;
                }
                TableItem[] tableItemArray = SQLiteAttachedDatabasesPage.this.attachedDatabasesTable.getItems();
                int n = tableItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem item = tableItemArray[n2];
                    if (item.getText(0).equals(attachDatabaseDialog.getName())) {
                        return;
                    }
                    ++n2;
                }
                TableItem tableItem = new TableItem(SQLiteAttachedDatabasesPage.this.attachedDatabasesTable, 0);
                tableItem.setText(0, attachDatabaseDialog.getName());
                tableItem.setText(1, attachDatabaseDialog.getFile());
            }
        });
        this.removeItem = UIUtils.createToolItem((ToolBar)toolbar, (String)SQLiteUIMessages.page_extensions_toolbar_remove, (DBPImage)UIIcon.DELETE, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = SQLiteAttachedDatabasesPage.this.attachedDatabasesTable.getSelectionIndex();
                SQLiteAttachedDatabasesPage.this.attachedDatabasesTable.remove(index);
                SQLiteAttachedDatabasesPage.this.attachedDatabasesTable.select(CommonUtils.clamp((int)index, (int)0, (int)(SQLiteAttachedDatabasesPage.this.attachedDatabasesTable.getItemCount() - 1)));
                SQLiteAttachedDatabasesPage.this.attachedDatabasesTable.notifyListeners(13, new Event());
            }
        });
        this.removeItem.setEnabled(false);
        this.attachedDatabasesTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SQLiteAttachedDatabasesPage.this.removeItem.setEnabled(SQLiteAttachedDatabasesPage.this.attachedDatabasesTable.getItemCount() > 0);
            }
        });
        this.useAttachedDatabases.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SQLiteAttachedDatabasesPage.this.updateTable();
            }
        });
        this.loadSettings();
        this.setControl((Control)tableComposite);
    }

    private void updateTable() {
        this.attachedDatabasesTable.setEnabled(this.useAttachedDatabases.getSelection());
        this.removeItem.setEnabled(this.useAttachedDatabases.getSelection() && this.attachedDatabasesTable.getItemCount() > 0);
        this.addItem.setEnabled(this.useAttachedDatabases.getSelection());
    }

    public void loadSettings() {
        super.loadSettings();
        DBPConnectionConfiguration connectionConfiguration = this.site.getActiveDataSource().getConnectionConfiguration();
        this.useAttachedDatabases.setSelection(CommonUtils.toBoolean((Object)connectionConfiguration.getProviderProperty("use-attached-databases")));
        if (this.useAttachedDatabases.getSelection() && !CommonUtils.isEmpty((String)connectionConfiguration.getProviderProperty("sqlite-attached-databases-names"))) {
            String[] names = connectionConfiguration.getProviderProperty("sqlite-attached-databases-names").split(",");
            String[] paths = connectionConfiguration.getProviderProperty("sqlite-attached-databased-paths").split(File.pathSeparator);
            int i = 0;
            while (i < names.length) {
                TableItem tableItem = new TableItem(this.attachedDatabasesTable, 0);
                tableItem.setText(0, names[i]);
                tableItem.setText(1, paths[i]);
                ++i;
            }
        }
        this.updateTable();
    }

    public void saveSettings(@NotNull DBPDataSourceContainer dataSource) {
        super.saveSettings(dataSource);
        DBPConnectionConfiguration connectionConfiguration = dataSource.getConnectionConfiguration();
        connectionConfiguration.setProviderProperty("use-attached-databases", CommonUtils.toString((Object)this.useAttachedDatabases.getSelection()));
        if (this.useAttachedDatabases.getSelection()) {
            ArrayList<String> names = new ArrayList<String>();
            ArrayList<String> paths = new ArrayList<String>();
            TableItem[] tableItemArray = this.attachedDatabasesTable.getItems();
            int n = tableItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem item = tableItemArray[n2];
                names.add(item.getText(0));
                paths.add(item.getText(1));
                ++n2;
            }
            connectionConfiguration.setProviderProperty("sqlite-attached-databases-names", String.join((CharSequence)",", names));
            connectionConfiguration.setProviderProperty("sqlite-attached-databased-paths", String.join((CharSequence)File.pathSeparator, paths));
        }
    }
}

