/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.teradata.ui.views;

import com.dbeaver.db.teradata.ui.TeradataMessages;
import com.dbeaver.db.teradata.ui.views.TeradataConnectionPageAdvanced;
import org.eclipse.jface.dialogs.IDialogPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.ext.generic.views.GenericConnectionPage;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionPageAbstract;
import org.jkiss.dbeaver.ui.dialogs.connection.DriverPropertiesDialogPage;
import org.jkiss.utils.CommonUtils;

public class TeradataConnectionPage
extends GenericConnectionPage {
    private Button enableTLS;

    @NotNull
    protected Control createDatabasePropsPanel(Composite parent) {
        this.enableTLS = UIUtils.createCheckbox((Composite)parent, (String)TeradataMessages.connection_page_checkbox_label_enable_TLS, (String)TeradataMessages.connection_page_checkbox_description_enable_TLS, (boolean)false, (int)2);
        this.enableTLS.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TeradataConnectionPage.this.updateHostPortAndUrl();
            }
        });
        return this.enableTLS;
    }

    protected boolean isConnectionPropertyOptional(String property) {
        return "database".equals(property);
    }

    private void updateHostPortAndUrl() {
        boolean enabled = this.enableTLS.getSelection();
        if (enabled) {
            this.setPortText(String.valueOf(443));
        } else {
            this.setPortText(String.valueOf(1025));
        }
    }

    public void loadSettings() {
        DBPConnectionConfiguration connectionInfo = this.site.getActiveDataSource().getConnectionConfiguration();
        this.enableTLS.setSelection(CommonUtils.toBoolean((Object)connectionInfo.getProviderProperty("use-tls-protocol@")));
        super.loadSettings();
    }

    public void saveSettings(DBPDataSourceContainer dataSource) {
        DBPConnectionConfiguration connectionInfo = dataSource.getConnectionConfiguration();
        if (this.enableTLS != null) {
            connectionInfo.setProviderProperty("use-tls-protocol@", String.valueOf(this.enableTLS.getSelection()));
        }
        if (!"teradata_LDAP".equals(connectionInfo.getAuthModelId())) {
            connectionInfo.setProviderProperty("use_ldap_mechanism@", Boolean.FALSE.toString());
        }
        super.saveSettings(dataSource);
    }

    public IDialogPage[] getDialogPages(boolean extrasOnly, boolean forceCreate) {
        return new IDialogPage[]{new TeradataConnectionPageAdvanced(), new DriverPropertiesDialogPage((ConnectionPageAbstract)this)};
    }
}

