/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.vertica.model.plan;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.data.json.JSONUtils;
import org.jkiss.dbeaver.model.exec.plan.DBCPlanCostNode;
import org.jkiss.dbeaver.model.exec.plan.DBCPlanNode;
import org.jkiss.dbeaver.model.impl.PropertyDescriptor;
import org.jkiss.dbeaver.model.impl.plan.AbstractExecutionPlanNode;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.preferences.DBPPropertyDescriptor;
import org.jkiss.dbeaver.model.preferences.DBPPropertySource;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.CommonUtils;

public class VerticaPlanNode
extends AbstractExecutionPlanNode
implements DBCPlanCostNode,
DBPPropertySource {
    private VerticaPlanNode parentNode;
    private Map<String, Object> attributes;
    private List<VerticaPlanNode> nested = new ArrayList<VerticaPlanNode>();
    private int pathId;
    private String pathName;
    private Double cost;
    private long rows;
    private long outRowSize;
    private String executeNode;
    private String table;

    VerticaPlanNode(@Nullable VerticaPlanNode parentNode, @NotNull Map<String, Object> data) {
        Map inner;
        Map outer;
        this.parentNode = parentNode;
        this.attributes = data;
        this.pathId = JSONUtils.getInteger(data, (String)"PATH_ID");
        this.pathName = JSONUtils.getString(data, (String)"PATH_NAME");
        this.cost = JSONUtils.getDouble(data, (String)"COST");
        this.rows = JSONUtils.getLong(data, (String)"ROWS", (long)0L);
        this.outRowSize = JSONUtils.getLong(data, (String)"OutRowSz(B)", (long)0L);
        this.executeNode = JSONUtils.getString(data, (String)"EXECUTE_NODE");
        this.table = JSONUtils.getString(data, (String)"TABLE");
        Map input = JSONUtils.getObject(data, (String)"INPUT");
        if (!input.isEmpty()) {
            this.nested.add(new VerticaPlanNode(this, input));
        }
        if (!(outer = JSONUtils.getObject(data, (String)"Outer")).isEmpty()) {
            this.nested.add(new VerticaPlanNode(this, outer));
        }
        if (!(inner = JSONUtils.getObject(data, (String)"Inner")).isEmpty()) {
            this.nested.add(new VerticaPlanNode(this, inner));
        }
    }

    VerticaPlanNode(@NotNull Map<String, Object> data, @Nullable VerticaPlanNode parentNode) {
        this.attributes = data;
        this.parentNode = parentNode;
    }

    @Property(viewable=true, order=1)
    public String getPathName() {
        return this.pathName;
    }

    @Property(viewable=true, order=2)
    public Number getNodeCost() {
        return this.cost;
    }

    @Property(viewable=true, order=3)
    public Number getNodeRowCount() {
        return this.rows;
    }

    @Property(viewable=true, order=4)
    public long getOutRowSize() {
        return this.outRowSize;
    }

    @Property(viewable=true, order=5)
    public String getExecuteNode() {
        return this.executeNode;
    }

    @Property(viewable=true, order=6)
    @Nullable
    public String getTable() {
        return this.table;
    }

    public Number getNodePercent() {
        return null;
    }

    public Number getNodeDuration() {
        return null;
    }

    public String getNodeName() {
        return "Node_" + CommonUtils.toString((Object)this.pathId);
    }

    public String getNodeType() {
        return this.pathName;
    }

    public DBCPlanNode getParent() {
        return this.parentNode;
    }

    public Collection<? extends DBCPlanNode> getNested() {
        return this.nested;
    }

    @NotNull
    Map<String, Object> getAttributes() {
        return this.attributes;
    }

    @NotNull
    public Object getEditableValue() {
        return this;
    }

    @NotNull
    public DBPPropertyDescriptor[] getProperties() {
        DBPPropertyDescriptor[] props = new DBPPropertyDescriptor[this.attributes.size()];
        int index = 0;
        for (Map.Entry<String, Object> attr : this.attributes.entrySet()) {
            props[index++] = new PropertyDescriptor("Details", attr.getKey(), attr.getKey(), null, String.class, false, null, null, false);
        }
        return props;
    }

    @Nullable
    public Object getPropertyValue(@Nullable DBRProgressMonitor monitor, @NotNull String id) {
        return this.attributes.get(id);
    }

    public boolean isPropertySet(@NotNull String id) {
        return false;
    }

    public boolean isPropertyResettable(@NotNull String id) {
        return false;
    }

    public void resetPropertyValue(@Nullable DBRProgressMonitor monitor, @NotNull String id) {
    }

    public void resetPropertyValueToDefault(@NotNull String id) {
    }

    public void setPropertyValue(@Nullable DBRProgressMonitor monitor, @NotNull String id, @Nullable Object value) {
    }
}

