/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.ycql.exec;

import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.cql.AsyncResultSet;
import com.datastax.oss.driver.api.core.cql.ColumnDefinitions;
import com.datastax.oss.driver.api.core.cql.SimpleStatement;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.dbeaver.db.ycql.exec.CasBaseStatement;
import com.dbeaver.db.ycql.exec.CasSession;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.qm.QMUtils;

public class CasSimpleStatement
extends CasBaseStatement {
    private Statement builtStatement;

    public CasSimpleStatement(CasSession session, String query) {
        super(session, query);
        this.builtStatement = SimpleStatement.newInstance((String)query);
        this.builtStatement = this.builtStatement.setConsistencyLevel(((CasSession)this.getSession()).getExecutionContext().getCurrentConsistencyLevel());
    }

    @Override
    public Statement getStatementImpl() {
        return this.builtStatement;
    }

    public boolean executeStatement() throws DBCException {
        if (((CasSession)this.getSession()).isLoggingEnabled()) {
            QMUtils.getDefaultHandler().handleStatementExecuteBegin((DBCStatement)this);
        }
        this.startBlock("Execute statement");
        try {
            CqlSession sessionImpl = ((CasSession)this.getSession()).getImpl();
            long timeoutMs = (long)this.statementTimeout * 1000L;
            if (timeoutMs > 0L) {
                this.builtStatement = this.builtStatement.setTimeout(Duration.ofMillis(timeoutMs));
            }
            this.resultSetFuture = sessionImpl.executeAsync(this.builtStatement);
            try {
                this.result = timeoutMs > 0L ? (AsyncResultSet)this.resultSetFuture.toCompletableFuture().get(timeoutMs, TimeUnit.SECONDS) : (AsyncResultSet)this.resultSetFuture.toCompletableFuture().get();
            }
            finally {
                this.resultSetFuture = null;
            }
            ColumnDefinitions resultColumns = this.result.getColumnDefinitions();
            if (resultColumns == null || resultColumns.size() == 0) {
                this.result = null;
            }
            boolean bl = this.result != null;
            return bl;
        }
        catch (Throwable e) {
            throw this.handleExecuteError(e);
        }
        finally {
            this.endBlock();
            if (((CasSession)this.getSession()).isLoggingEnabled()) {
                QMUtils.getDefaultHandler().handleStatementExecuteEnd((DBCStatement)this, -1L, this.executeError);
            }
        }
    }
}

