/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.ycql.model;

import com.dbeaver.db.ycql.model.CasDataSource;
import com.dbeaver.db.ycql.model.CasPrivilege;
import java.util.ArrayList;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.access.DBAPrivilegeGrant;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class CasPrivilegeGrant
implements DBAPrivilegeGrant,
DBSObject {
    private final CasDataSource dataSource;
    private final String userName;
    private final String resourceName;
    private final CasPrivilege[] privileges;

    public CasPrivilegeGrant(CasDataSource dataSource, String userName, String resourceName, List<String> permissions) {
        this.dataSource = dataSource;
        this.userName = userName;
        this.resourceName = resourceName;
        ArrayList<CasPrivilege> privilegeList = new ArrayList<CasPrivilege>();
        for (String permission : permissions) {
            CasPrivilege privilege = dataSource.getPrivilege(permission);
            privilegeList.add(privilege);
        }
        this.privileges = (CasPrivilege[])privilegeList.toArray(CasPrivilege[]::new);
    }

    @Property(viewable=true, order=1)
    public Object getSubject(@NotNull DBRProgressMonitor monitor) {
        return this.userName;
    }

    @Property(viewable=true, order=2)
    public Object getObject(@NotNull DBRProgressMonitor monitor) {
        return this.resourceName;
    }

    @Property(viewable=true, order=3)
    public CasPrivilege[] getPrivileges() {
        return this.privileges;
    }

    public boolean isGranted() {
        return true;
    }

    public String getDescription() {
        return null;
    }

    public DBSObject getParentObject() {
        return this.dataSource;
    }

    public DBPDataSource getDataSource() {
        return this.dataSource;
    }

    @NotNull
    public String getName() {
        return this.privileges[0].getName();
    }

    public boolean isPersisted() {
        return true;
    }
}

