/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.dpi.client;

import com.dbeaver.dpi.client.BundleProcessConfig;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.container.ModuleWire;
import org.eclipse.osgi.container.ModuleWiring;
import org.eclipse.osgi.internal.framework.EquinoxBundle;
import org.eclipse.osgi.internal.loader.EquinoxClassLoader;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.osgi.framework.Bundle;

public class BundleConfigGenerator {
    public static void generateBundleConfig(List<Bundle> bundles) {
        LinkedHashSet<Bundle> dependencies = new LinkedHashSet<Bundle>();
        for (Bundle bundle : bundles) {
            BundleConfigGenerator.collectBundleDependencies(bundle, dependencies);
        }
        System.out.println(dependencies);
    }

    private static void collectBundleDependencies(Bundle bundle, Set<Bundle> dependencies) {
        dependencies.add(bundle);
    }

    public static BundleProcessConfig generateBundleConfig(DBRProgressMonitor monitor, DBPDataSourceContainer dataSourceContainer) throws IOException {
        BundleProcessConfig processConfig = new BundleProcessConfig(monitor, dataSourceContainer.getId());
        BundleConfigGenerator.addBundleByName("com.dbeaver.dpi.server", processConfig, false);
        BundleConfigGenerator.addBundleByName("org.jkiss.utils", processConfig, true);
        if (!processConfig.isValid()) {
            throw new IOException("No OSGI bundles were configured");
        }
        processConfig.generateApplicationConfiguration();
        return processConfig;
    }

    private static void addBundleByName(@NotNull String bundleName, @NotNull BundleProcessConfig processConfig, boolean addDependencies) {
        ModuleWiring wiring;
        Bundle bundle = Platform.getBundle((String)bundleName);
        if (bundle instanceof EquinoxBundle && (wiring = ((EquinoxBundle)bundle).getModule().getCurrentRevision().getWiring()) != null) {
            BundleConfigGenerator.collectModuleWirings(wiring, processConfig, addDependencies);
        }
    }

    private static void addBundleFromClass(@NotNull Class<?> bundleClass, @NotNull BundleProcessConfig processConfig) {
        ModuleWiring wiring;
        ClassLoader classLoader = bundleClass.getClassLoader();
        if (classLoader instanceof EquinoxClassLoader && (wiring = ((EquinoxClassLoader)classLoader).getBundleLoader().getWiring()) != null) {
            BundleConfigGenerator.collectModuleWirings(wiring, processConfig, true);
        }
    }

    private static void collectModuleWirings(@NotNull ModuleWiring wiring, @NotNull BundleProcessConfig processConfig, boolean addDependencies) {
        if (processConfig.containsWiring(wiring)) {
            return;
        }
        processConfig.addWiring(wiring);
        if (addDependencies) {
            ModuleWiring providerWiring;
            List requiredModuleWires = wiring.getRequiredModuleWires("osgi.wiring.bundle");
            for (ModuleWire dWire : requiredModuleWires) {
                providerWiring = dWire.getProviderWiring();
                BundleConfigGenerator.collectModuleWirings(providerWiring, processConfig, true);
            }
            for (ModuleWire dWire : wiring.getRequiredModuleWires("osgi.wiring.package")) {
                providerWiring = dWire.getProviderWiring();
                BundleConfigGenerator.collectModuleWirings(providerWiring, processConfig, true);
            }
        }
    }
}

