/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.mockdata.engine.model.tasks;

import com.dbeaver.ee.mockdata.engine.internal.MockDataMessages;
import com.dbeaver.ee.mockdata.engine.model.tasks.EntityProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBStructUtils;
import org.jkiss.dbeaver.model.task.DBTTaskSettings;
import org.jkiss.dbeaver.runtime.DBWorkbench;

public class MockDataSettings
implements DBTTaskSettings<DBSObject> {
    private static final Log log = Log.getLog(MockDataSettings.class);
    private static final String PROP_SELECTED_ENTITY = "selectedEntity";
    public static final String NO_GENERATOR_LABEL = MockDataMessages.tools_mockdata_attribute_generator_skip;
    public static final String PROP_ENTITIES = "entities";
    private List<EntityProperties> entityPropertiesList;
    @Nullable
    private String selectedEntityName;
    private boolean isInitialized;

    public MockDataSettings() {
        this(Collections.emptyList());
    }

    public void setEntityPropertiesList(List<EntityProperties> entityPropertiesList) {
        this.entityPropertiesList = entityPropertiesList;
    }

    public MockDataSettings(@NotNull Collection<DBSObject> inputObjects) {
        this.entityPropertiesList = new ArrayList<EntityProperties>(inputObjects.size());
        for (DBSObject dbsObject : inputObjects) {
            if (dbsObject == null) continue;
            this.entityPropertiesList.add(new EntityProperties(dbsObject));
        }
    }

    public void init(@NotNull DBRProgressMonitor monitor) throws DBException {
        monitor.beginTask("Init mock data settings", 1);
        for (EntityProperties properties : this.entityPropertiesList) {
            if (properties.isInitFromTask()) continue;
            properties.init(monitor);
        }
        this.isInitialized = true;
    }

    public List<EntityProperties> getEntityPropertiesList() {
        return Collections.unmodifiableList(this.entityPropertiesList);
    }

    public void loadFrom(DBRProgressMonitor monitor, @NotNull List<Map<String, Object>> entitiesMap) throws DBException {
        this.entityPropertiesList = new ArrayList<EntityProperties>();
        for (Map<String, Object> map : entitiesMap) {
            Map selectedEntityMap = (Map)map.get("config");
            DBPProject project = DBWorkbench.getPlatform().getWorkspace().getProject(selectedEntityMap.get("project").toString());
            if (project == null) {
                return;
            }
            DBSObject object = DBUtils.findObjectById((DBRProgressMonitor)monitor, (DBPProject)project, (String)selectedEntityMap.get("entityId").toString());
            if (object == null) {
                return;
            }
            EntityProperties entityProperties = new EntityProperties(object);
            entityProperties.loadFrom(monitor, map);
            this.entityPropertiesList.add(entityProperties);
        }
    }

    public void saveTo(@NotNull Map<String, Object> map) {
        ArrayList<HashMap<String, Object>> entityMapList = new ArrayList<HashMap<String, Object>>();
        for (EntityProperties properties : this.entityPropertiesList) {
            HashMap<String, Object> entityMap = new HashMap<String, Object>();
            properties.saveTo(entityMap);
            entityMapList.add(entityMap);
        }
        map.put(PROP_ENTITIES, entityMapList);
    }

    @Nullable
    public EntityProperties getEntityProperties(@NotNull DBSEntity entity) {
        return this.entityPropertiesList.stream().filter(properties -> properties.getEntity().equals(entity)).findAny().orElse(null);
    }

    @Nullable
    public String getSelectedEntityName() {
        return this.selectedEntityName;
    }

    public void setSelectedEntityName(@Nullable String selectedEntityName) {
        this.selectedEntityName = selectedEntityName;
    }

    public void sortEntityProperties(DBRProgressMonitor monitor) {
        List entities = this.entityPropertiesList.stream().map(EntityProperties::getEntity).collect(Collectors.toList());
        ArrayList simpleTables = new ArrayList();
        ArrayList cyclicTables = new ArrayList();
        ArrayList views = new ArrayList();
        try {
            DBStructUtils.sortTableList((DBRProgressMonitor)monitor, entities, simpleTables, cyclicTables, views);
        }
        catch (DBException dBException) {
            log.warn((Object)"Unable to sort database entities!");
            return;
        }
        this.entityPropertiesList.sort((properties1, properties2) -> {
            DBSEntity entity1 = properties1.getEntity();
            DBSEntity entity2 = properties2.getEntity();
            int idx1 = views.indexOf(entity1);
            int idx2 = views.indexOf(entity2);
            if (idx1 != -1 || idx2 != -1) {
                return idx1 - idx2;
            }
            idx1 = cyclicTables.indexOf(entity1);
            idx2 = cyclicTables.indexOf(entity2);
            if (idx1 != -1 || idx2 != -1) {
                return idx1 - idx2;
            }
            return simpleTables.indexOf(entity1) - simpleTables.indexOf(entity2);
        });
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }
}

