-- Major schema update
-- Note: we can't drop columns to support backward compatibility when older version is run with newer workspace.

-- Deployment host information
CREATE TABLE {table_prefix}QM_DBEAVER_HOST (
    HOST_ID INTEGER AUTO_INCREMENT NOT NULL,

    MAC_ADDRESS CHAR(12) NOT NULL,
    HOST_NAME VARCHAR(1024) NOT NULL,
    IP_ADDRESS VARCHAR(48) NOT NULL,

    UPDATE_TIME TIMESTAMP NOT NULL,

    PRIMARY KEY (HOST_ID),
    UNIQUE (MAC_ADDRESS)
);

INSERT INTO {table_prefix}QM_DBEAVER_HOST(MAC_ADDRESS, HOST_NAME, IP_ADDRESS, UPDATE_TIME)
    VALUES ('000000000000', 'localhost', '127.0.0.1', CURRENT_TIMESTAMP);

-- User information
CREATE TABLE {table_prefix}QM_USER (
    USER_ID BIGINT AUTO_INCREMENT NOT NULL,

    DOMAIN_NAME VARCHAR(128) NOT NULL,
    USER_NAME VARCHAR(255) NOT NULL,

    UPDATE_TIME TIMESTAMP NOT NULL,

    PRIMARY KEY (USER_ID),
    UNIQUE (DOMAIN_NAME,USER_NAME)
);

INSERT INTO {table_prefix}QM_USER(USER_ID, USER_NAME, DOMAIN_NAME, UPDATE_TIME)
    VALUES (0, 'unknown', 'unknown', CURRENT_TIMESTAMP);

ALTER TABLE {table_prefix}QM_DBEAVER_DEPLOYMENT ALTER COLUMN HOST_NAME SET NULL;
ALTER TABLE {table_prefix}QM_DBEAVER_DEPLOYMENT ADD HOST_ID INTEGER DEFAULT 0 NOT NULL;
ALTER TABLE {table_prefix}QM_DBEAVER_DEPLOYMENT ADD PORT_NUMBER INTEGER DEFAULT 0 NOT NULL;
ALTER TABLE {table_prefix}QM_DBEAVER_DEPLOYMENT ADD UNIQUE (HOST_ID,INSTALL_PATH);

ALTER TABLE {table_prefix}QM_DBEAVER_VERSION ADD PRODUCT_NAME VARCHAR(64) DEFAULT 'DBeaver' NOT NULL;
ALTER TABLE {table_prefix}QM_DBEAVER_VERSION ALTER COLUMN UPDATE_DEPLOY_ID SET NULL;

ALTER TABLE {table_prefix}QM_DBEAVER_WORKSPACE ADD HOST_ID INTEGER DEFAULT 0 NOT NULL;
ALTER TABLE {table_prefix}QM_DBEAVER_WORKSPACE ADD UNIQUE (HOST_ID,WORKSPACE_PATH);
ALTER TABLE {table_prefix}QM_DBEAVER_WORKSPACE ADD FOREIGN KEY (HOST_ID) REFERENCES {table_prefix}QM_DBEAVER_HOST(HOST_ID);

ALTER TABLE {table_prefix}QM_DBEAVER_RUN ALTER COLUMN HOST_NAME SET NULL;
ALTER TABLE {table_prefix}QM_DBEAVER_RUN ADD USER_ID INTEGER DEFAULT 0 NOT NULL;

CREATE TABLE {table_prefix}QM_USER_SESSION (
    SESSION_ID BIGINT AUTO_INCREMENT NOT NULL,

    RUN_ID BIGINT NOT NULL,
    APP_SESSION_ID VARCHAR(64) NOT NULL,     -- Application-specific session ID. Unique within application run.

    USER_ID BIGINT NOT NULL,

    START_TIME TIMESTAMP NOT NULL,

    PRIMARY KEY (SESSION_ID),
    UNIQUE (RUN_ID,APP_SESSION_ID),
    FOREIGN KEY (USER_ID) REFERENCES {table_prefix}QM_USER(USER_ID),
    FOREIGN KEY (RUN_ID) REFERENCES {table_prefix}QM_DBEAVER_RUN(RUN_ID)
);

-- We can not change datasource primary key here.
-- We do this in QM model
ALTER TABLE {table_prefix}QM_DATASOURCE ADD WORKSPACE_ID INTEGER DEFAULT 1 NOT NULL;
ALTER TABLE {table_prefix}QM_DATASOURCE ADD FOREIGN KEY (WORKSPACE_ID) REFERENCES {table_prefix}QM_DBEAVER_WORKSPACE(WORKSPACE_ID);

ALTER TABLE {table_prefix}QM_CONNECTION ADD SESSION_ID BIGINT;
ALTER TABLE {table_prefix}QM_CONNECTION ADD WORKSPACE_ID INTEGER DEFAULT 1 NOT NULL;
ALTER TABLE {table_prefix}QM_CONNECTION ADD FOREIGN KEY (SESSION_ID) REFERENCES {table_prefix}QM_USER_SESSION(SESSION_ID);
