/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.runtime.security;

import com.dbeaver.model.DBPProjectAdvanced;
import java.io.BufferedReader;
import java.io.Console;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import javax.crypto.SecretKey;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceConfigurationStorage;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.impl.app.DefaultValueEncryptor;
import org.jkiss.dbeaver.registry.DataSourceConfigurationManagerNIO;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.ui.UIServiceSecurity;
import org.jkiss.utils.CommonUtils;

public class ConsoleServiceSecurityImpl
implements UIServiceSecurity {
    private static final Log log = Log.getLog(ConsoleServiceSecurityImpl.class);

    public String askForPassword(@NotNull String title, String message, @Nullable String defPassword, boolean emptyPasswordAllowed) {
        String password;
        block6: {
            if (DBWorkbench.getPlatform().getApplication().isHeadlessMode()) {
                log.error((Object)(title + "\nWARNING: User password requested in headless mode. Passing null value."));
                return null;
            }
            Console console = System.console();
            if (console != null) {
                console.printf(title + "\n", new Object[0]);
                char[] passwordArray = console.readPassword(message + ": ", new Object[0]);
                if (passwordArray == null || passwordArray.length == 0) {
                    return null;
                }
                return new String(passwordArray);
            }
            System.out.println(title);
            System.out.print(message + ": ");
            try {
                password = new BufferedReader(new InputStreamReader(System.in)).readLine();
                if (!CommonUtils.isEmpty((String)password)) break block6;
                return null;
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
        return password;
    }

    public String askForPassword(DBPProject project, String title, String message, String defPassword, boolean emptyPasswordAllowed) {
        return this.askForPassword(title, message, defPassword, emptyPasswordAllowed);
    }

    public String askForNewPassword(@NotNull String title, @Nullable String defPassword) {
        return this.askForPassword(title, "Enter new password", defPassword, false);
    }

    public String askForPasswordChange(@NotNull String title, @NotNull String currentPassword) {
        return null;
    }

    public boolean validatePassword(DBPProject project, String title, String message, boolean forceEncryption) {
        if (project instanceof DBPProjectAdvanced) {
            DBPProjectAdvanced projectAdvanced = (DBPProjectAdvanced)project;
            return this.validateProjectPassword(projectAdvanced, title, message);
        }
        return false;
    }

    private boolean validateProjectPassword(DBPProjectAdvanced project, String title, String message) {
        boolean isSecured = CommonUtils.toBoolean((Object)project.getProjectProperty("useProjectPassword"));
        if (!isSecured) {
            return true;
        }
        String password = this.askForPassword(title, message, null, false);
        if (password == null) {
            return false;
        }
        SecretKey key = DefaultValueEncryptor.makeSecretKeyFromPassword((String)password);
        if (!project.isValidSecretKey(key)) {
            System.out.println(title + "\nIncorrect password");
            return false;
        }
        return true;
    }

    public void resetProjectPassword(DBPProject project) throws DBException {
        if (project instanceof DBPProjectAdvanced) {
            DBPProjectAdvanced localProject = (DBPProjectAdvanced)project;
            DataSourceConfigurationManagerNIO configurationManager = new DataSourceConfigurationManagerNIO(project);
            for (DBPDataSourceConfigurationStorage configurationStorage : configurationManager.getConfigurationStorages()) {
                String credConfig = "credentials-config" + configurationStorage.getStorageSubId() + ".json";
                Path credentialsPath = project.getMetadataFolder(false).resolve(credConfig);
                if (Files.notExists(credentialsPath, new LinkOption[0])) {
                    credentialsPath = project.getAbsolutePath().resolve(credConfig);
                }
                if (Files.notExists(credentialsPath, new LinkOption[0])) {
                    log.error((Object)"Operation can not be performed, credentials file not found");
                }
                try {
                    Files.delete(credentialsPath);
                }
                catch (IOException e) {
                    log.error((Object)e.getMessage());
                }
            }
            localProject.setProjectPassword(null);
            localProject.setProjectProperty("useProjectPassword", (Object)Boolean.FALSE);
            if (localProject.isEncryptedProject()) {
                for (DBPDataSourceConfigurationStorage configurationStorage : configurationManager.getConfigurationStorages()) {
                    Path path = project.getMetadataFolder(false).resolve(configurationStorage.getStorageName());
                    if (Files.notExists(path, new LinkOption[0])) {
                        path = project.getAbsolutePath().resolve(configurationStorage.getStorageName());
                    }
                    if (Files.notExists(path, new LinkOption[0])) {
                        log.error((Object)"Operation can not be performed, datasource configuration file not found");
                    }
                    try {
                        Files.delete(path);
                    }
                    catch (IOException e) {
                        log.error((Object)e.getMessage());
                    }
                }
                localProject.setProjectProperty("secureProject", (Object)Boolean.FALSE);
            }
        } else {
            log.error((Object)"Operation is not supported for non local type of project");
        }
    }
}

