/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.tasks.ui;

import com.dbeaver.ee.tasks.ui.internal.TaskEEUIMessages;
import java.time.Duration;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.task.DBTTask;
import org.jkiss.dbeaver.model.task.DBTTaskSettings;
import org.jkiss.dbeaver.registry.task.TaskImpl;
import org.jkiss.dbeaver.tasks.ui.wizard.TaskConfigurationWIzardActionConfigurator;
import org.jkiss.dbeaver.tasks.ui.wizard.TaskConfigurationWizard;
import org.jkiss.dbeaver.ui.ActionUtils;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.DurationPickerDialog;
import org.jkiss.dbeaver.utils.DurationFormat;
import org.jkiss.dbeaver.utils.DurationFormatter;

public final class AdvancedTaskConfigurationWIzardActionConfigurator<T extends DBTTaskSettings>
extends TaskConfigurationWIzardActionConfigurator<T> {
    private TaskConfigurationWizard<T> wizard;
    private Button timeoutConfigurationButton;

    public void createControl(@NotNull Composite parent, TaskConfigurationWizard<T> object, @NotNull Runnable propertyChangeListener) {
        this.wizard = object;
        GridLayout layout = (GridLayout)parent.getLayout();
        ++layout.numColumns;
        this.timeoutConfigurationButton = this.createTimeoutConfigurationButton(parent, object);
    }

    protected void updateActions() {
        if (this.timeoutConfigurationButton != null) {
            this.timeoutConfigurationButton.setEnabled(this.wizard.getCurrentTask() != null);
        }
    }

    protected void enableActions(boolean enable) {
        if (this.timeoutConfigurationButton != null) {
            this.timeoutConfigurationButton.setEnabled(enable);
        }
    }

    @NotNull
    private Button createTimeoutConfigurationButton(@NotNull Composite parent, @NotNull TaskConfigurationWizard<T> wizard) {
        MenuManager manager = new MenuManager();
        Button button = UIUtils.createDialogButton((Composite)parent, null, (SelectionListener)SelectionListener.widgetSelectedAdapter(e -> {
            Button button1 = (Button)e.widget;
            Point location = button1.toDisplay(0, 0);
            location.y += button1.getSize().y;
            Menu menu = manager.createContextMenu((Control)button1);
            menu.setLocation(location);
            menu.setVisible(true);
        }));
        button.setLayoutData((Object)new GridData(128));
        button.addDisposeListener(e -> manager.dispose());
        Runnable updateButtonVisuals = () -> {
            TaskImpl task;
            DBTTask dBTTask = wizard.getCurrentTask();
            if (dBTTask instanceof TaskImpl && (task = (TaskImpl)dBTTask).getMaxExecutionTime().isPositive()) {
                button.setImage(DBeaverIcons.getImage((DBPImage)UIIcon.CLOCK_STOP));
                button.setToolTipText(NLS.bind((String)TaskEEUIMessages.task_config_wizard_max_execution_time_set, (Object)DurationFormatter.format((Duration)task.getMaxExecutionTime(), (DurationFormat)DurationFormat.LONG)));
            } else {
                button.setImage(DBeaverIcons.getImage((DBPImage)UIIcon.CLOCK_START));
                button.setToolTipText(TaskEEUIMessages.task_config_wizard_max_execution_time_unset);
            }
        };
        manager.setRemoveAllWhenShown(true);
        manager.addMenuListener(m -> {
            class PresetTimeoutAction
            extends Action {
                private final Duration duration;
                private final /* synthetic */ TaskConfigurationWizard val$wizard;
                private final /* synthetic */ Runnable val$updateButtonVisuals;

                public PresetTimeoutAction(@NotNull int index, Duration duration, TaskConfigurationWizard taskConfigurationWizard, Runnable runnable) {
                    this.val$wizard = taskConfigurationWizard;
                    this.val$updateButtonVisuals = runnable;
                    super(PresetTimeoutAction.makeActionName(index, duration), 8);
                    this.duration = duration;
                }

                /*
                 * WARNING - void declaration
                 */
                public void run() {
                    void task;
                    DBTTask dBTTask = this.val$wizard.getCurrentTask();
                    if (!(dBTTask instanceof TaskImpl)) {
                        return;
                    }
                    TaskImpl taskImpl = (TaskImpl)dBTTask;
                    task.setMaxExecutionTime(this.duration);
                    this.val$updateButtonVisuals.run();
                }

                public boolean isChecked() {
                    TaskImpl task;
                    DBTTask dBTTask = this.val$wizard.getCurrentTask();
                    return dBTTask instanceof TaskImpl && (task = (TaskImpl)dBTTask).getMaxExecutionTime().equals(this.duration);
                }

                @NotNull
                private static String makeActionName(int index, @NotNull Duration duration) {
                    return ActionUtils.getLabelWithIndexMnemonic((String)DurationFormatter.format((Duration)duration, (DurationFormat)DurationFormat.LONG), (int)index);
                }
            }
            TaskImpl task;
            class CustomTimeoutAction
            extends Action {
                private final /* synthetic */ TaskConfigurationWizard val$wizard;
                private final /* synthetic */ Runnable val$updateButtonVisuals;

                public CustomTimeoutAction(TaskConfigurationWizard taskConfigurationWizard, Runnable runnable) {
                    this.val$wizard = taskConfigurationWizard;
                    this.val$updateButtonVisuals = runnable;
                    super(TaskEEUIMessages.task_config_wizard_max_execution_time_customize, 1);
                }

                /*
                 * WARNING - void declaration
                 */
                public void run() {
                    void task;
                    DBTTask dBTTask = this.val$wizard.getCurrentTask();
                    if (!(dBTTask instanceof TaskImpl)) {
                        return;
                    }
                    TaskImpl taskImpl = (TaskImpl)dBTTask;
                    DurationPickerDialog dialog = new DurationPickerDialog(this.val$wizard.getShell(), TaskEEUIMessages.task_config_wizard_max_execution_time_customize_title, task.getMaxExecutionTime());
                    if (dialog.open() == 0) {
                        task.setMaxExecutionTime(dialog.getDuration());
                        this.val$updateButtonVisuals.run();
                    }
                }
            }
            m.add((IAction)new CustomTimeoutAction(wizard, updateButtonVisuals));
            m.add((IContributionItem)new Separator());
            List<Duration> presets = List.of(Duration.ofMinutes(1L), Duration.ofMinutes(5L), Duration.ofMinutes(30L), Duration.ofHours(1L));
            int i = 0;
            while (i < presets.size()) {
                m.add((IAction)new PresetTimeoutAction(i, presets.get(i), wizard, updateButtonVisuals));
                ++i;
            }
            DBTTask dBTTask = wizard.getCurrentTask();
            if (dBTTask instanceof TaskImpl && (task = (TaskImpl)dBTTask).getMaxExecutionTime().isPositive()) {
                Duration duration = task.getMaxExecutionTime();
                if (!presets.contains(duration)) {
                    m.add((IAction)new PresetTimeoutAction(presets.size(), duration, wizard, updateButtonVisuals));
                }
                m.add((IContributionItem)new Separator());
                class DisableTimeoutAction
                extends Action {
                    private final /* synthetic */ TaskConfigurationWizard val$wizard;
                    private final /* synthetic */ Runnable val$updateButtonVisuals;

                    public DisableTimeoutAction(TaskConfigurationWizard taskConfigurationWizard, Runnable runnable) {
                        this.val$wizard = taskConfigurationWizard;
                        this.val$updateButtonVisuals = runnable;
                        super(TaskEEUIMessages.task_config_wizard_max_execution_time_disable);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public void run() {
                        void task;
                        DBTTask dBTTask = this.val$wizard.getCurrentTask();
                        if (!(dBTTask instanceof TaskImpl)) {
                            return;
                        }
                        TaskImpl taskImpl = (TaskImpl)dBTTask;
                        task.setMaxExecutionTime(Duration.ZERO);
                        this.val$updateButtonVisuals.run();
                    }
                }
                m.add((IAction)new DisableTimeoutAction(wizard, updateButtonVisuals));
            }
        });
        updateButtonVisuals.run();
        return button;
    }
}

