/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.tasks.ui;

import com.dbeaver.ee.tasks.ui.internal.TaskEEUIMessages;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.part.ViewPart;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.app.DBPWorkspace;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.task.DBTScheduler;
import org.jkiss.dbeaver.model.task.DBTTask;
import org.jkiss.dbeaver.model.task.DBTTaskEvent;
import org.jkiss.dbeaver.model.task.DBTTaskFolder;
import org.jkiss.dbeaver.model.task.DBTTaskFolderEvent;
import org.jkiss.dbeaver.model.task.DBTTaskListener;
import org.jkiss.dbeaver.model.task.DBTTaskManager;
import org.jkiss.dbeaver.model.task.DBTTaskRun;
import org.jkiss.dbeaver.model.task.DBTTaskScheduleInfo;
import org.jkiss.dbeaver.registry.task.TaskRegistry;
import org.jkiss.dbeaver.registry.timezone.TimezoneRegistry;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.tasks.ui.view.DatabaseTasksTree;
import org.jkiss.dbeaver.tasks.ui.view.DatabaseTasksView;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.IRefreshablePart;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.ListContentProvider;
import org.jkiss.dbeaver.ui.controls.ViewerColumnController;
import org.jkiss.dbeaver.ui.dialogs.ConfirmationDialog;
import org.jkiss.dbeaver.ui.navigator.actions.NavigatorHandlerProjectSetActive;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

public class ScheduledTasksView
extends ViewPart
implements DBTTaskListener,
IRefreshablePart {
    private static final Log log = Log.getLog(ScheduledTasksView.class);
    public static final String VIEW_ID = "com.dbeaver.tasks.scheduler";
    private final DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss", Locale.getDefault()).withZone(ZoneId.of(TimezoneRegistry.getUserDefaultTimezone()));
    private TableViewer tableViewer;
    private Table stTable;

    public void createPartControl(Composite parent) {
        Composite composite = UIUtils.createComposite((Composite)parent, (int)1);
        this.tableViewer = new TableViewer(composite, 65540);
        this.stTable = this.tableViewer.getTable();
        this.stTable.setLayoutData((Object)new GridData(1808));
        this.stTable.setHeaderVisible(true);
        this.setTitleToolTip(TaskEEUIMessages.task_scheduled_tasks_view_title_tooltip);
        ViewerColumnController scheduledTasksViewerController = new ViewerColumnController("scheduledTasks", (ColumnViewer)this.tableViewer);
        this.createScheduleTableColumn(scheduledTasksViewerController, TaskEEUIMessages.task_scheduled_tasks_view_task_column, ScheduledTaskDetails::getName, (CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((ScheduledTaskDetails)element).getName();
            }

            public void update(ViewerCell cell) {
                DBPImage icon;
                if (cell.getColumnIndex() == 0 && (icon = ((ScheduledTaskDetails)cell.getElement()).getIcon()) != null) {
                    cell.setImage(DBeaverIcons.getImage((DBPImage)icon));
                }
                cell.setText(((ScheduledTaskDetails)cell.getElement()).getName());
            }
        });
        this.createScheduleTableColumn(scheduledTasksViewerController, TaskEEUIMessages.task_scheduled_tasks_view_project_column, ScheduledTaskDetails::getProjectName, null);
        this.createScheduleTableColumn(scheduledTasksViewerController, TaskEEUIMessages.task_scheduled_tasks_view_type_column, ScheduledTaskDetails::getTaskType, null);
        this.createScheduleTableColumn(scheduledTasksViewerController, TaskEEUIMessages.task_scheduled_tasks_view_last_run_column, ScheduledTaskDetails::getStartTime, null);
        this.createScheduleTableColumn(scheduledTasksViewerController, TaskEEUIMessages.task_scheduled_tasks_view_next_run_column, ScheduledTaskDetails::getNextRun, null);
        this.tableViewer.addDoubleClickListener(event -> {
            DatabaseTasksView taskView;
            ScheduledTaskDetails selectedScheduledTask = (ScheduledTaskDetails)((IStructuredSelection)event.getSelection()).getFirstElement();
            DBTTask task = selectedScheduledTask.getTask();
            if (!task.getProject().equals(DBWorkbench.getPlatform().getWorkspace().getActiveProject())) {
                ConfirmationDialog dialog = new ConfirmationDialog(this.getSite().getShell(), TaskEEUIMessages.task_scheduled_tasks_view_switch_project_title, null, NLS.bind((String)TaskEEUIMessages.task_scheduled_tasks_view_switch_project_message, (Object)task.getProject().getName()), 2, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0, null, false);
                if (dialog.open() == 2) {
                    NavigatorHandlerProjectSetActive.setActiveProject((DBPProject)task.getProject());
                } else {
                    return;
                }
            }
            if ((taskView = (DatabaseTasksView)UIUtils.findView((IWorkbenchWindow)UIUtils.getActiveWorkbenchWindow(), (String)"org.jkiss.dbeaver.tasks")) == null) {
                IWorkbenchWindow activeWorkbenchWindow = UIUtils.getActiveWorkbenchWindow();
                try {
                    taskView = (DatabaseTasksView)activeWorkbenchWindow.getActivePage().showView("org.jkiss.dbeaver.tasks");
                }
                catch (CoreException e) {
                    log.error((Object)"Error opening task view from scheduled task", (Throwable)e);
                }
            }
            if (taskView != null) {
                DatabaseTasksTree tasksTree = taskView.getTasksTree();
                if (tasksTree == null) {
                    return;
                }
                this.getSite().getPage().bringToTop((IWorkbenchPart)taskView);
                ArrayList<DBTTaskFolder> taskFolders = new ArrayList<DBTTaskFolder>();
                DBTTaskFolder taskFolder = task.getTaskFolder();
                while (taskFolder != null) {
                    taskFolders.add(taskFolder);
                    taskFolder = taskFolder.getParentFolder();
                }
                int i = taskFolders.size() - 1;
                while (i >= 0) {
                    DBTTaskFolder folder = (DBTTaskFolder)taskFolders.get(i);
                    if (folder != null) {
                        tasksTree.getViewer().setExpandedState((Object)folder, true);
                    }
                    --i;
                }
                tasksTree.getViewer().setSelection((ISelection)new StructuredSelection((Object)task), true);
            }
        });
        this.tableViewer.setContentProvider((IContentProvider)new ListContentProvider());
        scheduledTasksViewerController.createColumns(false);
        this.loadScheduledTasks();
    }

    private void loadScheduledTasks() {
        AbstractJob loader = new AbstractJob("Load scheduled tasks"){

            protected IStatus run(DBRProgressMonitor monitor) {
                DBTScheduler scheduler = TaskRegistry.getInstance().getActiveSchedulerInstance();
                if (scheduler == null) {
                    return Status.OK_STATUS;
                }
                try {
                    DBPWorkspace workspace = DBWorkbench.getPlatform().getWorkspace();
                    scheduler.refreshScheduledTasks(monitor);
                    List allScheduledTasks = scheduler.getAllScheduledTasks();
                    List<ScheduledTaskDetails> detailsList = allScheduledTasks.stream().map(tsi -> ScheduledTasksView.this.resolveTaskDetails((DBTTaskScheduleInfo)tsi, workspace)).filter(Objects::nonNull).sorted(Comparator.comparing(ScheduledTaskDetails::getName)).toList();
                    UIUtils.asyncExec(() -> ScheduledTasksView.this.populateTasks(detailsList));
                }
                catch (DBException e) {
                    return GeneralUtils.makeExceptionStatus((Throwable)e);
                }
                return Status.OK_STATUS;
            }
        };
        loader.schedule();
    }

    @Nullable
    private ScheduledTaskDetails resolveTaskDetails(DBTTaskScheduleInfo tsi, DBPWorkspace workspace) {
        String projectId = tsi.getProjectId();
        DBPProject project = null;
        if (projectId != null && (project = workspace.getProjectById(projectId)) == null) {
            log.debug((Object)("Project '" + projectId + "' not recognized"));
        }
        if (project == null) {
            project = this.getProject(tsi.getTaskId(), workspace);
        }
        if (project == null) {
            return null;
        }
        DBTTaskManager tm = project.getTaskManager();
        DBTTask task = tm.getTaskByName(tsi.getTaskId());
        if (task == null) {
            task = tm.getTaskById(tsi.getTaskId());
        }
        return new ScheduledTaskDetails(tsi, project, task);
    }

    @Nullable
    private DBPProject getProject(String taskId, DBPWorkspace workspace) {
        return workspace.getProjects().stream().filter(project -> {
            DBTTaskManager tm = project.getTaskManager();
            return tm.getTaskByName(taskId) != null || tm.getTaskById(taskId) != null;
        }).findFirst().orElse(null);
    }

    private void populateTasks(List<ScheduledTaskDetails> tasks) {
        this.tableViewer.setInput(tasks);
        UIUtils.asyncExec(() -> UIUtils.packColumns((Table)this.stTable, (boolean)true));
    }

    public void setFocus() {
    }

    public void handleTaskEvent(@NotNull DBTTaskEvent event) {
    }

    public void handleTaskFolderEvent(@NotNull DBTTaskFolderEvent event) {
    }

    public IRefreshablePart.RefreshResult refreshPart(Object source, boolean force) {
        this.loadScheduledTasks();
        return IRefreshablePart.RefreshResult.REFRESHED;
    }

    private void createScheduleTableColumn(@NotNull ViewerColumnController<?, ?> columnController, @NotNull String name, final @NotNull Function<ScheduledTaskDetails, Object> getter, @Nullable CellLabelProvider labelProvider) {
        EditingSupport editingSupport = new EditingSupport((ColumnViewer)this.tableViewer){

            protected CellEditor getCellEditor(Object element) {
                return new TextCellEditor((Composite)ScheduledTasksView.this.tableViewer.getTable());
            }

            protected boolean canEdit(Object element) {
                return false;
            }

            protected Object getValue(Object element) {
                return getter.apply((ScheduledTaskDetails)element);
            }

            protected void setValue(Object element, Object value) {
            }
        };
        if (labelProvider != null) {
            columnController.addColumn(name, null, 16384, true, true, false, null, labelProvider, editingSupport);
        } else {
            columnController.addColumn(name, null, 16384, true, true, o -> CommonUtils.toString(getter.apply((ScheduledTaskDetails)o)), editingSupport);
        }
    }

    static /* synthetic */ ScheduledTaskDetails access$0(ScheduledTasksView scheduledTasksView, DBTTaskScheduleInfo dBTTaskScheduleInfo, DBPWorkspace dBPWorkspace) {
        return scheduledTasksView.resolveTaskDetails(dBTTaskScheduleInfo, dBPWorkspace);
    }

    private class ScheduledTaskDetails {
        private final DBTTaskScheduleInfo scheduleInfo;
        private final DBPProject project;
        private final DBTTask task;

        public ScheduledTaskDetails(DBTTaskScheduleInfo scheduleInfo, DBPProject project, DBTTask task) {
            this.scheduleInfo = scheduleInfo;
            this.project = project;
            this.task = task;
        }

        @NotNull
        public String getName() {
            return this.task == null ? this.scheduleInfo.getTaskId() : this.task.getName();
        }

        @Nullable
        public DBPImage getIcon() {
            if (this.task != null && this.task.getType().getIcon() != null) {
                return this.task.getType().getIcon();
            }
            return null;
        }

        @NotNull
        public String getStartTime() {
            return Optional.ofNullable(this.task).map(DBTTask::getLastRun).map(DBTTaskRun::getStartTime).map(Date::toInstant).map(ScheduledTasksView.this.formatter::format).orElse("");
        }

        @Nullable
        public String getProjectName() {
            return this.project != null ? this.project.getName() : this.scheduleInfo.getProjectId();
        }

        @NotNull
        public String getTaskType() {
            return this.task != null ? this.task.getType().getName() : "N/A";
        }

        @Nullable
        public String getNextRun() {
            return this.scheduleInfo.getNextRunInfo();
        }

        public DBTTaskScheduleInfo getScheduleInfo() {
            return this.scheduleInfo;
        }

        public DBPProject getProject() {
            return this.project;
        }

        public DBTTask getTask() {
            return this.task;
        }
    }
}

