/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.tasks.ui;

import com.dbeaver.ee.tasks.ShellTaskSettings;
import com.dbeaver.ee.tasks.ui.ShellTaskWizard;
import com.dbeaver.ee.tasks.ui.internal.TaskEEUIMessages;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.TextWithOpenFolder;
import org.jkiss.dbeaver.ui.dialogs.ActiveWizardPage;
import org.jkiss.utils.CommonUtils;

public class ShellTaskWizardPageSettings
extends ActiveWizardPage<ShellTaskWizard> {
    private Text commandText;
    private Button waitForProcessToFinishCheckbox;
    private Spinner waitForProcessToFinishSpinner;
    private Button pauseAfterProcessFinishCheckbox;
    private Spinner pauseAfterProcessFinishSpinner;
    private TextWithOpenFolder workingDirectoryText;

    public ShellTaskWizardPageSettings() {
        super(TaskEEUIMessages.task_shell_wizard_title);
        this.setTitle(TaskEEUIMessages.task_shell_wizard_settings_title);
        this.setDescription(TaskEEUIMessages.task_shell_wizard_settings_description);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        ShellTaskSettings settings = ((ShellTaskWizard)this.getWizard()).getSettings();
        Composite composite = UIUtils.createComposite((Composite)parent, (int)1);
        composite.setLayoutData((Object)new GridData(1808));
        ModifyListener modifyListener = e -> this.updatePageCompletion();
        Group scriptGroup = UIUtils.createControlGroup((Composite)composite, (String)TaskEEUIMessages.task_shell_wizard_settings_command_title, (int)1, (int)1808, (int)0);
        this.commandText = new Text((Composite)scriptGroup, 2050);
        this.commandText.setLayoutData((Object)new GridData(1808));
        this.commandText.setText(settings.getCommand());
        this.commandText.addModifyListener(modifyListener);
        Group optionsGroup = UIUtils.createControlGroup((Composite)composite, (String)TaskEEUIMessages.task_shell_wizard_settings_options_title, (int)2, (int)0, (int)0);
        SelectionAdapter selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ShellTaskWizardPageSettings.this.updatePageCompletion();
            }
        };
        this.waitForProcessToFinishCheckbox = UIUtils.createCheckbox((Composite)optionsGroup, (String)TaskEEUIMessages.task_shell_wizard_settings_options_wait_for_process_to_finish_label, (settings.getProcessTimeoutMs() != null ? 1 : 0) != 0);
        this.waitForProcessToFinishCheckbox.addSelectionListener((SelectionListener)selectionListener);
        this.waitForProcessToFinishSpinner = UIUtils.createSpinner((Composite)optionsGroup, (String)TaskEEUIMessages.task_shell_wizard_settings_options_wait_for_process_to_finish_tip, (int)-1, (int)-1, (int)Integer.MAX_VALUE);
        this.waitForProcessToFinishSpinner.addModifyListener(modifyListener);
        this.pauseAfterProcessFinishCheckbox = UIUtils.createCheckbox((Composite)optionsGroup, (String)TaskEEUIMessages.task_shell_wizard_settings_options_pause_after_process_finish_label, (settings.getPauseAfterExecuteMs() != null ? 1 : 0) != 0);
        this.pauseAfterProcessFinishCheckbox.addSelectionListener((SelectionListener)selectionListener);
        this.pauseAfterProcessFinishSpinner = UIUtils.createSpinner((Composite)optionsGroup, (String)"", (int)0, (int)0, (int)Integer.MAX_VALUE);
        this.pauseAfterProcessFinishSpinner.addModifyListener(modifyListener);
        GridData gd = new GridData(768);
        gd.widthHint = UIUtils.getFontHeight((Font)this.getFont()) * 30;
        UIUtils.createControlLabel((Composite)optionsGroup, (String)TaskEEUIMessages.task_shell_wizard_settings_options_working_directory_label);
        this.workingDirectoryText = new TextWithOpenFolder((Composite)optionsGroup, TaskEEUIMessages.task_shell_wizard_settings_options_working_directory_title);
        this.workingDirectoryText.setLayoutData((Object)gd);
        this.workingDirectoryText.getTextControl().addModifyListener(modifyListener);
        this.workingDirectoryText.setText(CommonUtils.notEmpty((String)settings.getWorkingDirectory()));
        this.setControl((Control)composite);
    }

    protected void updatePageCompletion() {
        super.updatePageCompletion();
        ((ShellTaskWizard)this.getWizard()).updateTaskButtons();
        this.waitForProcessToFinishSpinner.setEnabled(this.waitForProcessToFinishCheckbox.getSelection());
        this.pauseAfterProcessFinishSpinner.setEnabled(this.pauseAfterProcessFinishCheckbox.getSelection());
    }

    protected boolean determinePageCompletion() {
        if (CommonUtils.isEmptyTrimmed((String)this.commandText.getText())) {
            this.setErrorMessage(TaskEEUIMessages.task_shell_wizard_settings_options_error_command_is_empty);
            return false;
        }
        return super.determinePageCompletion();
    }

    public void savePageSettings() {
        ShellTaskSettings settings = ((ShellTaskWizard)this.getWizard()).getSettings();
        settings.setCommand(this.commandText.getText());
        settings.setProcessTimeoutMs(this.waitForProcessToFinishSpinner.getEnabled() ? Integer.valueOf(this.waitForProcessToFinishSpinner.getSelection()) : null);
        settings.setPauseAfterExecuteMs(this.pauseAfterProcessFinishSpinner.getEnabled() ? Integer.valueOf(this.pauseAfterProcessFinishSpinner.getSelection()) : null);
        settings.setWorkingDirectory(CommonUtils.nullIfEmpty((String)this.workingDirectoryText.getText()));
    }
}

