/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.jdbc.base;

import com.dbeaver.jdbc.JdbcDriverInstanceProvider;
import com.dbeaver.jdbc.base.OsgiContext;
import java.io.IOException;
import java.nio.file.Path;
import java.sql.Driver;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.stream.Stream;
import org.jkiss.api.CompositeObjectId;
import org.jkiss.api.FileSystemPathProvider;
import org.jkiss.api.ObjectWithContextParameters;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;

public class BaseJdbcUtils {
    private static final boolean OSGI_ACCESSIBLE = BaseJdbcUtils.isOsgiClassesVisible();

    public static boolean isOsgiAvailable() {
        return OSGI_ACCESSIBLE;
    }

    @Nullable
    public static Driver getDriverInstance(@NotNull CompositeObjectId ref) {
        return BaseJdbcUtils.getServices(JdbcDriverInstanceProvider.class, BaseJdbcUtils.class.getClassLoader()).map(provider -> provider.get(ref)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    @NotNull
    public static Path resolvePathByStringOrUri(@NotNull ObjectWithContextParameters object, @NotNull String pathUri) throws IOException {
        FileSystemPathProvider pathProvider = BaseJdbcUtils.getServices(FileSystemPathProvider.class, BaseJdbcUtils.class.getClassLoader()).findFirst().orElse(null);
        if (pathProvider != null) {
            return pathProvider.getPathByStringOrUri(object, pathUri);
        }
        return Path.of(pathUri, new String[0]);
    }

    private static boolean isOsgiClassesVisible() {
        try {
            Class.forName("org.osgi.framework.Bundle");
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    @NotNull
    private static <T> Stream<T> getServices(@NotNull Class<T> service, @NotNull ClassLoader loader) {
        return Stream.concat(BaseJdbcUtils.isOsgiAvailable() ? OsgiContext.getOsgiServices(service, loader) : Stream.empty(), BaseJdbcUtils.getServiceLoaderServices(service, loader));
    }

    private static <T> Stream<? extends T> getServiceLoaderServices(@NotNull Class<T> service, @NotNull ClassLoader loader) {
        return ServiceLoader.load(service, loader).stream().map(ServiceLoader.Provider::get);
    }
}

