/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.jdbc.files.csv;

import com.dbeaver.jdbc.files.FFFileReaderFactory;
import com.dbeaver.jdbc.files.csv.CsvCustomReader;
import com.dbeaver.jdbc.files.csv.CsvProperties;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import org.jkiss.code.NotNull;
import org.jkiss.utils.csv.CSVParser;
import org.jkiss.utils.csv.CSVParserBuilder;
import org.jkiss.utils.csv.CSVReader;
import org.jkiss.utils.csv.CSVReaderBuilder;

public class CsvReaderFactory
implements FFFileReaderFactory<CsvCustomReader, CsvProperties> {
    @NotNull
    public CsvCustomReader createReader(@NotNull Path path, @NotNull CsvProperties properties) throws IOException {
        BufferedReader reader = Files.newBufferedReader(path, StandardCharsets.UTF_8);
        CSVParser csvParser = new CSVParserBuilder().withEscapeChar(properties.escapeChar()).withQuoteChar(properties.quoteChar()).withSeparator(properties.separator()).withStrictQuotes(properties.strictQuotes()).withIgnoreLeadingWhiteSpace(properties.ignoreLeadingWhitespace()).withIgnoreQuotations(properties.ignoreQuotations()).withFieldAsNull(properties.nullFieldIndicator()).build();
        CSVReader csvReader = new CSVReaderBuilder((Reader)reader).withCSVParser(csvParser).build();
        return new CsvCustomReader(csvReader, properties.trimWhitespaces());
    }
}

