/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.jdbc.files.json;

import com.dbeaver.jdbc.files.FFFileReader;
import com.dbeaver.jdbc.files.FFFileReaderFactory;
import com.dbeaver.jdbc.files.json.JsonNode;
import com.dbeaver.jdbc.files.json.JsonProperties;
import com.dbeaver.jdbc.files.json.reader.JsonCompositeFormatRider;
import com.dbeaver.jdbc.files.json.reader.JsonSimpleFormatReader;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import org.jkiss.code.NotNull;

public class JsonFileReaderFactory
implements FFFileReaderFactory<FFFileReader<JsonNode<?>>, JsonProperties> {
    @NotNull
    public FFFileReader<JsonNode<?>> createReader(@NotNull Path path, @NotNull JsonProperties properties) throws IOException {
        JsonReader jsonReader = new JsonReader((Reader)Files.newBufferedReader(path));
        jsonReader.setStrictness(properties.strictness());
        JsonToken token = jsonReader.peek();
        return switch (token) {
            case JsonToken.BEGIN_ARRAY -> new JsonSimpleFormatReader(jsonReader);
            case JsonToken.BEGIN_OBJECT -> new JsonCompositeFormatRider(jsonReader);
            default -> throw new IOException("Invalid JSON file format: " + String.valueOf(token));
        };
    }
}

