/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.jdbc.files.parquet;

import com.dbeaver.jdbc.files.FFFileReader;
import com.dbeaver.jdbc.files.parquet.ParquetValue;
import java.io.IOException;
import org.apache.parquet.column.page.PageReadStore;
import org.apache.parquet.example.data.Group;
import org.apache.parquet.example.data.simple.convert.GroupRecordConverter;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.io.ColumnIOFactory;
import org.apache.parquet.io.MessageColumnIO;
import org.apache.parquet.io.RecordReader;
import org.apache.parquet.io.api.RecordMaterializer;
import org.apache.parquet.schema.MessageType;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.utils.function.ThrowableSupplier;

public class ParquetFileReader
implements FFFileReader<ParquetValue> {
    private final org.apache.parquet.hadoop.ParquetFileReader reader;
    private final MessageType schema;
    private RecordReader<Group> currentRecordReader;
    private long rowsRemaining;
    private boolean tableOpened;
    private boolean finished;

    public ParquetFileReader(org.apache.parquet.hadoop.ParquetFileReader reader) throws IOException {
        this.reader = reader;
        ParquetMetadata footer = reader.getFooter();
        this.schema = footer.getFileMetaData().getSchema();
        this.tableOpened = false;
        this.finished = false;
    }

    @NotNull
    public MessageType getSchema() {
        return this.schema;
    }

    public boolean openNextTable() throws IOException {
        return (Boolean)ParquetFileReader.withErrorHandling(this::openNextTable0);
    }

    private boolean openNextTable0() throws IOException {
        if (!this.tableOpened) {
            this.tableOpened = true;
            this.loadNextRowGroup();
            return true;
        }
        return false;
    }

    @Nullable
    public String getCurrentTable() {
        return null;
    }

    @Nullable
    public ParquetValue[] readRow() throws IOException {
        return (ParquetValue[])ParquetFileReader.withErrorHandling(this::readRow0);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    private ParquetValue[] readRow0() throws IOException {
        if (this.tableOpened && !this.finished) ** GOTO lbl6
        return null;
lbl-1000:
        // 1 sources

        {
            this.loadNextRowGroup();
            if (!this.finished) continue;
            return null;
lbl6:
            // 2 sources

            ** while (this.currentRecordReader == null || this.rowsRemaining <= 0L)
        }
lbl7:
        // 1 sources

        group = (Group)this.currentRecordReader.read();
        --this.rowsRemaining;
        fieldCount = this.schema.getFieldCount();
        row = new ParquetValue[fieldCount];
        i = 0;
        while (i < fieldCount) {
            row[i] = new ParquetValue(group, i);
            ++i;
        }
        return row;
    }

    public void close() throws IOException {
        this.reader.close();
    }

    private void loadNextRowGroup() throws IOException {
        PageReadStore pages = this.reader.readNextRowGroup();
        if (pages == null) {
            this.finished = true;
            this.currentRecordReader = null;
            this.rowsRemaining = 0L;
        } else {
            this.rowsRemaining = pages.getRowCount();
            MessageColumnIO columnIO = new ColumnIOFactory().getColumnIO(this.schema);
            this.currentRecordReader = columnIO.getRecordReader(pages, (RecordMaterializer)new GroupRecordConverter(this.schema));
        }
    }

    private static <T, E extends Exception> T withErrorHandling(@NotNull ThrowableSupplier<T, E> action) throws E {
        try {
            return (T)action.get();
        }
        catch (NoClassDefFoundError e) {
            throw new LinkageError("Required Parquet or compression-codec classes are missing from the runtime class-path. Add the Apache Parquet libraries (e.g. 'org.apache.parquet:parquet-hadoop') and any codec you use, such as Snappy ('org.xerial.snappy:snappy-java'), Zstd, LZ4, etc., then restart the application. See the installation guide: https://dbeaver.com/docs/dbeaver/Database-driver-Parquet/", e);
        }
    }
}

