/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.jdbc.files.parquet;

import com.dbeaver.jdbc.files.FFFileReaderFactory;
import com.dbeaver.jdbc.files.parquet.ParquetFileReader;
import com.dbeaver.jdbc.files.parquet.ParquetInputFile;
import com.dbeaver.jdbc.files.parquet.ParquetProperties;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Logger;
import org.apache.parquet.io.InputFile;
import org.apache.parquet.io.LocalInputFile;
import org.jkiss.code.NotNull;
import org.jkiss.utils.IOUtils;

class ParquetFileReaderFactory
implements FFFileReaderFactory<ParquetFileReader, ParquetProperties> {
    private static final Logger log = Logger.getLogger(ParquetFileReaderFactory.class.getName());
    @NotNull
    private final CompletableFuture<Void> connectionClosedFuture;
    private final Map<Path, Path> tmpFiles = new HashMap<Path, Path>();
    private volatile Path tmpFolder;

    ParquetFileReaderFactory(@NotNull CompletableFuture<Void> connectionClosedFuture) {
        this.connectionClosedFuture = connectionClosedFuture;
    }

    @NotNull
    public ParquetFileReader createReader(@NotNull Path path, @NotNull ParquetProperties properties) throws IOException {
        try {
            Path localPath = this.getLocalPath(path, properties);
            ParquetInputFile file = new ParquetInputFile(path, new LocalInputFile(localPath));
            org.apache.parquet.hadoop.ParquetFileReader parquetFileReader = org.apache.parquet.hadoop.ParquetFileReader.open((InputFile)file);
            return new ParquetFileReader(parquetFileReader);
        }
        catch (Exception e) {
            throw new IOException("Failed to open Parquet file: " + String.valueOf(path), e);
        }
    }

    @NotNull
    private Path getLocalPath(@NotNull Path path, @NotNull ParquetProperties properties) throws IOException {
        if (IOUtils.isLocalFile((String)path.toUri().toString())) {
            return path;
        }
        return this.tmpFiles.computeIfAbsent(path, p -> {
            try {
                return ParquetFileReaderFactory.createTmpCopy(p, this.getLocalTempFolder(properties));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    @NotNull
    private static Path createTmpCopy(@NotNull Path source, @NotNull Path destinationDir) throws IOException {
        Path tempFile = Files.createTempFile(destinationDir, source.getFileName().toString() + "-", ".tmp", new FileAttribute[0]);
        try {
            Throwable throwable = null;
            Object var4_5 = null;
            try (InputStream is = Files.newInputStream(source, new OpenOption[0]);){
                Throwable throwable2 = null;
                Object var7_10 = null;
                try (OutputStream os = Files.newOutputStream(tempFile, new OpenOption[0]);){
                    IOUtils.copyStream((InputStream)is, (OutputStream)os);
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
            return tempFile;
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
            Files.delete(tempFile);
            return Files.copy(source, tempFile, new CopyOption[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Path getLocalTempFolder(ParquetProperties properties) throws IOException {
        if (this.tmpFolder != null) {
            return this.tmpFolder;
        }
        ParquetFileReaderFactory parquetFileReaderFactory = this;
        synchronized (parquetFileReaderFactory) {
            if (this.tmpFolder != null) {
                return this.tmpFolder;
            }
            this.tmpFolder = this.createTempFolder(properties);
            this.connectionClosedFuture.whenComplete((ignored, throwable) -> {
                try {
                    IOUtils.deleteDirectory((Path)this.tmpFolder);
                }
                catch (IOException iOException) {
                    log.warning("Failed to delete temporary folder: " + String.valueOf(this.tmpFolder));
                }
            });
            return this.tmpFolder;
        }
    }

    private Path createTempFolder(ParquetProperties properties) throws IOException {
        Path localTempFolder = properties.tmpFolder();
        if (localTempFolder == null) {
            return Files.createTempDirectory("dbeaver-parquet-", new FileAttribute[0]);
        }
        Files.createDirectories(localTempFolder, new FileAttribute[0]);
        return localTempFolder;
    }
}

