/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.jdbc.files.parquet;

import com.dbeaver.jdbc.files.FFDataFileMetadataReader;
import com.dbeaver.jdbc.files.FFDataSourceScanner;
import com.dbeaver.jdbc.files.FFDataSourceScannerFactory;
import com.dbeaver.jdbc.files.FFDataSourceScannerImpl;
import com.dbeaver.jdbc.files.FFExternalMetadataReader;
import com.dbeaver.jdbc.files.FFExternalMetadataReaderImpl;
import com.dbeaver.jdbc.files.FFFileScannerFactory;
import com.dbeaver.jdbc.files.FFFileScannerImpl;
import com.dbeaver.jdbc.files.FFOrderMappingStrategy;
import com.dbeaver.jdbc.files.FFPropertiesFactory;
import com.dbeaver.jdbc.files.FFStructureMappingStrategy;
import com.dbeaver.jdbc.files.FFTableNameFactory;
import com.dbeaver.jdbc.files.FFTablePropertiesParser;
import com.dbeaver.jdbc.files.FFTableReaderFactory;
import com.dbeaver.jdbc.files.GenericTableNameFactory;
import com.dbeaver.jdbc.files.api.FFConnection;
import com.dbeaver.jdbc.files.api.FFDataSource;
import com.dbeaver.jdbc.files.api.FFDataSourceFormat;
import com.dbeaver.jdbc.files.api.FFDatabaseMetaData;
import com.dbeaver.jdbc.files.api.FFJdbcDriver;
import com.dbeaver.jdbc.files.database.FFDatabase;
import com.dbeaver.jdbc.files.parquet.ParquetDatabaseMetaData;
import com.dbeaver.jdbc.files.parquet.ParquetFileReaderFactory;
import com.dbeaver.jdbc.files.parquet.ParquetMetadataReader;
import com.dbeaver.jdbc.files.parquet.ParquetProperties;
import com.dbeaver.jdbc.files.parquet.ParquetTableProperties;
import com.dbeaver.jdbc.files.parquet.ParquetTablePropertiesParser;
import com.dbeaver.jdbc.files.parquet.ParquetTableReaderFactory;
import com.dbeaver.jdbc.files.parquet.ParquetValue;
import java.io.IOException;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import org.jkiss.code.NotNull;

public class ParquetJdbcDriver
extends FFJdbcDriver<ParquetValue, ParquetTableProperties, ParquetProperties> {
    public static final String DRIVER_NAME = "DBeaver Parquet JDBC Driver";
    public static final String DRIVER_PREFIX = "jdbc:dbeaver:file:parquet:";
    public static final int DRIVER_VERSION_MAJOR = 1;
    public static final int DRIVER_VERSION_MINOR = 0;

    static {
        try {
            DriverManager.registerDriver((Driver)((Object)new ParquetJdbcDriver()));
        }
        catch (SQLException e) {
            throw new RuntimeException("Error registering driver", e);
        }
    }

    public ParquetJdbcDriver() {
        super(DRIVER_PREFIX, 1, 0);
    }

    @NotNull
    public String getDriverIdentifier() {
        return DRIVER_NAME;
    }

    @NotNull
    protected FFDatabaseMetaData createDatabaseMetaData(@NotNull FFConnection connection, @NotNull String url, @NotNull FFDatabase database) {
        return new ParquetDatabaseMetaData(connection, url, database, this.getPropertiesFactory());
    }

    @NotNull
    public FFDataSourceFormat getSupportedDataSourceFormat() {
        return FFDataSourceFormat.PARQUET;
    }

    @NotNull
    public FFFileScannerFactory<ParquetValue, ParquetTableProperties, ParquetProperties> getFileScannerFactory() {
        return (dataSource, connectionClosedFuture) -> {
            ParquetFileReaderFactory parquetFileReaderFactory = new ParquetFileReaderFactory(connectionClosedFuture);
            ParquetTableReaderFactory readerFactory = new ParquetTableReaderFactory((ParquetProperties)dataSource.properties(), parquetFileReaderFactory);
            return new FFFileScannerImpl((FFTableNameFactory)new GenericTableNameFactory(dataSource), (FFDataFileMetadataReader)new ParquetMetadataReader((ParquetProperties)dataSource.properties(), parquetFileReaderFactory), (FFExternalMetadataReader)new FFExternalMetadataReaderImpl((FFTablePropertiesParser)new ParquetTablePropertiesParser()), (FFTableReaderFactory)readerFactory, (FFStructureMappingStrategy)new FFOrderMappingStrategy());
        };
    }

    @NotNull
    public FFDataSourceScannerFactory<ParquetValue, ParquetTableProperties, ParquetProperties> getDataSourceScannerFactory() {
        return new FFDataSourceScannerFactory<ParquetValue, ParquetTableProperties, ParquetProperties>(){

            @NotNull
            public FFDataSourceScanner<ParquetValue, ParquetTableProperties, ParquetProperties> createDataSourceScanner(@NotNull FFDataSource<ParquetProperties> dataSource, @NotNull CompletableFuture<Void> connectionClosedFuture) throws IOException {
                return new FFDataSourceScannerImpl(ParquetJdbcDriver.this.getFileScannerFactory().createScanner(dataSource, connectionClosedFuture));
            }
        };
    }

    @NotNull
    public FFPropertiesFactory<ParquetProperties> getPropertiesFactory() {
        return new FFPropertiesFactory<ParquetProperties>(){

            public ParquetProperties createProperties(Properties properties) {
                return new ParquetProperties(properties);
            }

            public ParquetProperties createProperties(Map<String, String> properties) {
                return new ParquetProperties(properties);
            }
        };
    }
}

